; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc --mtriple=loongarch64 --mattr=+lsx < %s | FileCheck %s

define void @fdiv_v4f32(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: fdiv_v4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vfdiv.s $vr0, $vr0, $vr1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x float>, ptr %a0
  %v1 = load <4 x float>, ptr %a1
  %v2 = fdiv <4 x float> %v0, %v1
  store <4 x float> %v2, ptr %res
  ret void
}

define void @fdiv_v2f64(ptr %res, ptr %a0, ptr %a1) nounwind {
; CHECK-LABEL: fdiv_v2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vld $vr1, $a2, 0
; CHECK-NEXT:    vfdiv.d $vr0, $vr0, $vr1
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %v1 = load <2 x double>, ptr %a1
  %v2 = fdiv <2 x double> %v0, %v1
  store <2 x double> %v2, ptr %res
  ret void
}

;; 1.0 / vec
define void @one_fdiv_v4f32(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: one_fdiv_v4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vfrecip.s $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <4 x float>, ptr %a0
  %div = fdiv <4 x float> <float 1.0, float 1.0, float 1.0, float 1.0>, %v0
  store <4 x float> %div, ptr %res
  ret void
}

define void @one_fdiv_v2f64(ptr %res, ptr %a0) nounwind {
; CHECK-LABEL: one_fdiv_v2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vld $vr0, $a1, 0
; CHECK-NEXT:    vfrecip.d $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a0, 0
; CHECK-NEXT:    ret
entry:
  %v0 = load <2 x double>, ptr %a0
  %div = fdiv <2 x double> <double 1.0, double 1.0>, %v0
  store <2 x double> %div, ptr %res
  ret void
}
