; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

define i1 @test_decompose_sub_nsw_sgt_nonneg(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @test_decompose_sub_nsw_sgt_nonneg(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SUB:%.*]] = sub nsw i32 [[Y]], [[X]]
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[SUB]], 10
; CHECK-NEXT:    br i1 [[COND]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; CHECK:       [[IF_THEN]]:
; CHECK-NEXT:    ret i1 true
; CHECK:       [[IF_ELSE]]:
; CHECK-NEXT:    ret i1 true
;
entry:
  %sub = sub nsw i32 %y, %x
  %cond = icmp sgt i32 %sub, 10
  br i1 %cond, label %if.then, label %if.else

if.then:
  %ret = icmp slt i32 %x, %y
  ret i1 %ret

if.else:
  ret i1 true
}

define i1 @test_decompose_sub_nsw_sgt_zero(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @test_decompose_sub_nsw_sgt_zero(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SUB:%.*]] = sub nsw i32 [[Y]], [[X]]
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[SUB]], 0
; CHECK-NEXT:    br i1 [[COND]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; CHECK:       [[IF_THEN]]:
; CHECK-NEXT:    ret i1 true
; CHECK:       [[IF_ELSE]]:
; CHECK-NEXT:    ret i1 true
;
entry:
  %sub = sub nsw i32 %y, %x
  %cond = icmp sgt i32 %sub, 0
  br i1 %cond, label %if.then, label %if.else

if.then:
  %ret = icmp slt i32 %x, %y
  ret i1 %ret

if.else:
  ret i1 true
}

define i1 @test_decompose_sub_nsw_sgt_zero_inv(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @test_decompose_sub_nsw_sgt_zero_inv(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SUB:%.*]] = sub nsw i32 [[Y]], [[X]]
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[SUB]], 10
; CHECK-NEXT:    br i1 [[COND]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; CHECK:       [[IF_THEN]]:
; CHECK-NEXT:    ret i1 false
; CHECK:       [[IF_ELSE]]:
; CHECK-NEXT:    ret i1 true
;
entry:
  %sub = sub nsw i32 %y, %x
  %cond = icmp sgt i32 %sub, 10
  br i1 %cond, label %if.then, label %if.else

if.then:
  %ret = icmp sge i32 %x, %y
  ret i1 %ret

if.else:
  ret i1 true
}

define i1 @test_decompose_sub_nonsw_sgt_zero(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @test_decompose_sub_nonsw_sgt_zero(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[Y]], [[X]]
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[SUB]], 10
; CHECK-NEXT:    br i1 [[COND]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; CHECK:       [[IF_THEN]]:
; CHECK-NEXT:    [[RET:%.*]] = icmp slt i32 [[X]], [[Y]]
; CHECK-NEXT:    ret i1 [[RET]]
; CHECK:       [[IF_ELSE]]:
; CHECK-NEXT:    ret i1 true
;
entry:
  %sub = sub i32 %y, %x
  %cond = icmp sgt i32 %sub, 10
  br i1 %cond, label %if.then, label %if.else

if.then:
  %ret = icmp slt i32 %x, %y
  ret i1 %ret

if.else:
  ret i1 true
}

define i1 @test_decompose_sub_nsw_sgt_neg(i32 %x, i32 %y) {
; CHECK-LABEL: define i1 @test_decompose_sub_nsw_sgt_neg(
; CHECK-SAME: i32 [[X:%.*]], i32 [[Y:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SUB:%.*]] = sub nsw i32 [[Y]], [[X]]
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[SUB]], -10
; CHECK-NEXT:    br i1 [[COND]], label %[[IF_THEN:.*]], label %[[IF_ELSE:.*]]
; CHECK:       [[IF_THEN]]:
; CHECK-NEXT:    [[RET:%.*]] = icmp slt i32 [[X]], [[Y]]
; CHECK-NEXT:    ret i1 [[RET]]
; CHECK:       [[IF_ELSE]]:
; CHECK-NEXT:    ret i1 true
;
entry:
  %sub = sub nsw i32 %y, %x
  %cond = icmp sgt i32 %sub, -10
  br i1 %cond, label %if.then, label %if.else

if.then:
  %ret = icmp slt i32 %x, %y
  ret i1 %ret

if.else:
  ret i1 true
}
