#include "TelepathyQt/_gen/svc-call.h"

#include "TelepathyQt/_gen/svc-call.moc.hpp"

#include <TelepathyQt/Constants>
#include <TelepathyQt/MethodInvocationContext>

namespace Tp
{
namespace Service
{

CallContentAdaptor::CallContentAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(streamsAdded(const Tp::ObjectPathList&)), SIGNAL(StreamsAdded(const Tp::ObjectPathList&)));
    connect(adaptee, SIGNAL(streamsRemoved(const Tp::ObjectPathList&, const Tp::CallStateReason&)), SIGNAL(StreamsRemoved(const Tp::ObjectPathList&, const Tp::CallStateReason&)));
}

CallContentAdaptor::~CallContentAdaptor()
{
}

QStringList CallContentAdaptor::Interfaces() const
{
    return qvariant_cast< QStringList >(adaptee()->property("interfaces"));
}

QString CallContentAdaptor::Name() const
{
    return qvariant_cast< QString >(adaptee()->property("name"));
}

uint CallContentAdaptor::Type() const
{
    return qvariant_cast< uint >(adaptee()->property("type"));
}

uint CallContentAdaptor::Disposition() const
{
    return qvariant_cast< uint >(adaptee()->property("disposition"));
}

Tp::ObjectPathList CallContentAdaptor::Streams() const
{
    return qvariant_cast< Tp::ObjectPathList >(adaptee()->property("streams"));
}

void CallContentAdaptor::Remove(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("remove(Tp::Service::CallContentAdaptor::RemoveContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RemoveContextPtr ctx = RemoveContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "remove",
        Q_ARG(Tp::Service::CallContentAdaptor::RemoveContextPtr, ctx));
}

CallContentInterfaceDTMFAdaptor::CallContentInterfaceDTMFAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(tonesDeferred(const QString&)), SIGNAL(TonesDeferred(const QString&)));
    connect(adaptee, SIGNAL(sendingTones(const QString&)), SIGNAL(SendingTones(const QString&)));
    connect(adaptee, SIGNAL(stoppedTones(bool)), SIGNAL(StoppedTones(bool)));
}

CallContentInterfaceDTMFAdaptor::~CallContentInterfaceDTMFAdaptor()
{
}

bool CallContentInterfaceDTMFAdaptor::CurrentlySendingTones() const
{
    return qvariant_cast< bool >(adaptee()->property("currentlySendingTones"));
}

QString CallContentInterfaceDTMFAdaptor::DeferredTones() const
{
    return qvariant_cast< QString >(adaptee()->property("deferredTones"));
}

void CallContentInterfaceDTMFAdaptor::StartTone(uchar event, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("startTone(uchar,Tp::Service::CallContentInterfaceDTMFAdaptor::StartToneContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    StartToneContextPtr ctx = StartToneContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "startTone",
        Q_ARG(uchar, event),
        Q_ARG(Tp::Service::CallContentInterfaceDTMFAdaptor::StartToneContextPtr, ctx));
}

void CallContentInterfaceDTMFAdaptor::StopTone(const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("stopTone(Tp::Service::CallContentInterfaceDTMFAdaptor::StopToneContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    StopToneContextPtr ctx = StopToneContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "stopTone",
        Q_ARG(Tp::Service::CallContentInterfaceDTMFAdaptor::StopToneContextPtr, ctx));
}

void CallContentInterfaceDTMFAdaptor::MultipleTones(const QString& tones, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("multipleTones(QString,Tp::Service::CallContentInterfaceDTMFAdaptor::MultipleTonesContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    MultipleTonesContextPtr ctx = MultipleTonesContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "multipleTones",
        Q_ARG(QString, tones),
        Q_ARG(Tp::Service::CallContentInterfaceDTMFAdaptor::MultipleTonesContextPtr, ctx));
}

CallInterfaceMuteAdaptor::CallInterfaceMuteAdaptor(const QDBusConnection& bus, QObject* adaptee, QObject* parent)
    : Tp::AbstractAdaptor(bus, adaptee, parent)
{
    connect(adaptee, SIGNAL(muteStateChanged(uint)), SIGNAL(MuteStateChanged(uint)));
}

CallInterfaceMuteAdaptor::~CallInterfaceMuteAdaptor()
{
}

uint CallInterfaceMuteAdaptor::LocalMuteState() const
{
    return qvariant_cast< uint >(adaptee()->property("localMuteState"));
}

void CallInterfaceMuteAdaptor::RequestMuted(bool muted, const QDBusMessage& dbusMessage)
{
    if (adaptee()->metaObject()->indexOfMethod("requestMuted(bool,Tp::Service::CallInterfaceMuteAdaptor::RequestMutedContextPtr)") < 0) {
        dbusConnection().send(dbusMessage.createErrorReply(TP_QT_ERROR_NOT_IMPLEMENTED, QLatin1String("Not implemented")));
        return;
    }

    RequestMutedContextPtr ctx = RequestMutedContextPtr(
            new Tp::MethodInvocationContext<  >(dbusConnection(), dbusMessage));
    QMetaObject::invokeMethod(adaptee(), "requestMuted",
        Q_ARG(bool, muted),
        Q_ARG(Tp::Service::CallInterfaceMuteAdaptor::RequestMutedContextPtr, ctx));
}

}
}