/* mpris2-watcher.c generated by valac 0.12.0, the Vala compiler
 * generated from mpris2-watcher.vala, do not modify */

/*
Copyright 2010 Canonical Ltd.

Authors:
    Conor Curran <conor.curran@canonical.com>

This program is free software: you can redistribute it and/or modify it 
under the terms of the GNU General Public License version 3, as published 
by the Free Software Foundation.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranties of 
MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along 
with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/parser.h>
#include <libxml/tree.h>


#define TYPE_MPRIS2_WATCHER (mpris2_watcher_get_type ())
#define MPRIS2_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS2_WATCHER, Mpris2Watcher))
#define MPRIS2_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MPRIS2_WATCHER, Mpris2WatcherClass))
#define IS_MPRIS2_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS2_WATCHER))
#define IS_MPRIS2_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MPRIS2_WATCHER))
#define MPRIS2_WATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MPRIS2_WATCHER, Mpris2WatcherClass))

typedef struct _Mpris2Watcher Mpris2Watcher;
typedef struct _Mpris2WatcherClass Mpris2WatcherClass;
typedef struct _Mpris2WatcherPrivate Mpris2WatcherPrivate;

#define TYPE_FREE_DESKTOP_OBJECT (free_desktop_object_get_type ())
#define FREE_DESKTOP_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FREE_DESKTOP_OBJECT, FreeDesktopObject))
#define IS_FREE_DESKTOP_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FREE_DESKTOP_OBJECT))
#define FREE_DESKTOP_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FREE_DESKTOP_OBJECT, FreeDesktopObjectIface))

typedef struct _FreeDesktopObject FreeDesktopObject;
typedef struct _FreeDesktopObjectIface FreeDesktopObjectIface;

#define TYPE_FREE_DESKTOP_OBJECT_PROXY (free_desktop_object_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_MPRIS_ROOT (mpris_root_get_type ())
#define MPRIS_ROOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_ROOT, MprisRoot))
#define IS_MPRIS_ROOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_ROOT))
#define MPRIS_ROOT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MPRIS_ROOT, MprisRootIface))

typedef struct _MprisRoot MprisRoot;
typedef struct _MprisRootIface MprisRootIface;

#define TYPE_MPRIS_ROOT_PROXY (mpris_root_proxy_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Mpris2WatcherCheckForActiveClientsData Mpris2WatcherCheckForActiveClientsData;

#define TYPE_FREE_DESKTOP_INTROSPECTABLE (free_desktop_introspectable_get_type ())
#define FREE_DESKTOP_INTROSPECTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FREE_DESKTOP_INTROSPECTABLE, FreeDesktopIntrospectable))
#define IS_FREE_DESKTOP_INTROSPECTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FREE_DESKTOP_INTROSPECTABLE))
#define FREE_DESKTOP_INTROSPECTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FREE_DESKTOP_INTROSPECTABLE, FreeDesktopIntrospectableIface))

typedef struct _FreeDesktopIntrospectable FreeDesktopIntrospectable;
typedef struct _FreeDesktopIntrospectableIface FreeDesktopIntrospectableIface;

#define TYPE_FREE_DESKTOP_INTROSPECTABLE_PROXY (free_desktop_introspectable_proxy_get_type ())

struct _Mpris2Watcher {
	GObject parent_instance;
	Mpris2WatcherPrivate * priv;
};

struct _Mpris2WatcherClass {
	GObjectClass parent_class;
};

struct _FreeDesktopObjectIface {
	GTypeInterface parent_iface;
	void (*list_names) (FreeDesktopObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (FreeDesktopObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _Mpris2WatcherPrivate {
	FreeDesktopObject* fdesktop_obj;
};

struct _MprisRootIface {
	GTypeInterface parent_iface;
	void (*Quit) (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Quit_finish) (MprisRoot* self, GAsyncResult* _res_, GError** error);
	void (*Raise) (MprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Raise_finish) (MprisRoot* self, GAsyncResult* _res_, GError** error);
	gboolean (*get_HasTracklist) (MprisRoot* self);
	void (*set_HasTracklist) (MprisRoot* self, gboolean value);
	gboolean (*get_CanQuit) (MprisRoot* self);
	void (*set_CanQuit) (MprisRoot* self, gboolean value);
	gboolean (*get_CanRaise) (MprisRoot* self);
	void (*set_CanRaise) (MprisRoot* self, gboolean value);
	gchar* (*get_Identity) (MprisRoot* self);
	void (*set_Identity) (MprisRoot* self, const gchar* value);
	gchar* (*get_DesktopEntry) (MprisRoot* self);
	void (*set_DesktopEntry) (MprisRoot* self, const gchar* value);
};

struct _Mpris2WatcherCheckForActiveClientsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Mpris2Watcher* self;
	gchar** interfaces;
	gint interfaces_length1;
	gint _interfaces_size_;
	gint _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint __tmp2__size_;
	GError * e;
	gchar** address_collection;
	int address_collection_length1;
	int address_it;
	gchar* _tmp3_;
	gchar* address;
	gboolean _tmp4_;
	MprisRoot* _tmp5_;
	MprisRoot* mpris2_root;
	gboolean _tmp6_;
	gboolean use_playlists;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError * _inner_error_;
};

struct _FreeDesktopIntrospectableIface {
	GTypeInterface parent_iface;
	gchar* (*Introspect) (FreeDesktopIntrospectable* self, GError** error);
};


static gpointer mpris2_watcher_parent_class = NULL;

GType mpris2_watcher_get_type (void) G_GNUC_CONST;
GType free_desktop_object_proxy_get_type (void) G_GNUC_CONST;
guint free_desktop_object_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType free_desktop_object_get_type (void) G_GNUC_CONST;
#define MPRIS2_WATCHER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MPRIS2_WATCHER, Mpris2WatcherPrivate))
enum  {
	MPRIS2_WATCHER_DUMMY_PROPERTY
};
Mpris2Watcher* mpris2_watcher_new (void);
Mpris2Watcher* mpris2_watcher_construct (GType object_type);
static void mpris2_watcher_check_for_active_clients_data_free (gpointer _data);
void mpris2_watcher_check_for_active_clients (Mpris2Watcher* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris2_watcher_check_for_active_clients_finish (Mpris2Watcher* self, GAsyncResult* _res_);
static gboolean mpris2_watcher_check_for_active_clients_co (Mpris2WatcherCheckForActiveClientsData* data);
void free_desktop_object_list_names (FreeDesktopObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** free_desktop_object_list_names_finish (FreeDesktopObject* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void mpris2_watcher_check_for_active_clients_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
#define MPRIS_PREFIX "org.mpris.MediaPlayer2."
GType mpris_root_proxy_get_type (void) G_GNUC_CONST;
guint mpris_root_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType mpris_root_get_type (void) G_GNUC_CONST;
static MprisRoot* mpris2_watcher_create_mpris_root (Mpris2Watcher* self, const gchar* name);
static gboolean mpris2_watcher_supports_playlists (Mpris2Watcher* self, const gchar* name);
gchar* mpris_root_get_DesktopEntry (MprisRoot* self);
static void mpris2_watcher_name_changes_detected (Mpris2Watcher* self, FreeDesktopObject* dbus_obj, const gchar* name, const gchar* previous_owner, const gchar* current_owner);
#define MPRIS_MEDIA_PLAYER_PATH "/org/mpris/MediaPlayer2"
GType free_desktop_introspectable_proxy_get_type (void) G_GNUC_CONST;
guint free_desktop_introspectable_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType free_desktop_introspectable_get_type (void) G_GNUC_CONST;
gchar* free_desktop_introspectable_Introspect (FreeDesktopIntrospectable* self, GError** error);
static gboolean mpris2_watcher_parse_interfaces (Mpris2Watcher* self, const gchar* interface_info);
static void g_cclosure_user_marshal_VOID__STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * mpris2_watcher_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define FREEDESKTOP_SERVICE "org.freedesktop.DBus"
#define FREEDESKTOP_OBJECT "/org/freedesktop/DBus"
static void _mpris2_watcher_name_changes_detected_free_desktop_object_name_owner_changed (FreeDesktopObject* _sender, const gchar* name, const gchar* old_owner, const gchar* new_owner, gpointer self);
static void mpris2_watcher_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


Mpris2Watcher* mpris2_watcher_construct (GType object_type) {
	Mpris2Watcher * self = NULL;
	self = (Mpris2Watcher*) g_object_new (object_type, NULL);
	return self;
}


Mpris2Watcher* mpris2_watcher_new (void) {
	return mpris2_watcher_construct (TYPE_MPRIS2_WATCHER);
}


static void mpris2_watcher_check_for_active_clients_data_free (gpointer _data) {
	Mpris2WatcherCheckForActiveClientsData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (Mpris2WatcherCheckForActiveClientsData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void mpris2_watcher_check_for_active_clients (Mpris2Watcher* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	Mpris2WatcherCheckForActiveClientsData* _data_;
	_data_ = g_slice_new0 (Mpris2WatcherCheckForActiveClientsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, mpris2_watcher_check_for_active_clients);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, mpris2_watcher_check_for_active_clients_data_free);
	_data_->self = _g_object_ref0 (self);
	mpris2_watcher_check_for_active_clients_co (_data_);
}


void mpris2_watcher_check_for_active_clients_finish (Mpris2Watcher* self, GAsyncResult* _res_) {
	Mpris2WatcherCheckForActiveClientsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void mpris2_watcher_check_for_active_clients_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	Mpris2WatcherCheckForActiveClientsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	mpris2_watcher_check_for_active_clients_co (data);
}


static gboolean mpris2_watcher_check_for_active_clients_co (Mpris2WatcherCheckForActiveClientsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->interfaces_length1 = 0;
	data->_interfaces_size_ = 0;
	data->_state_ = 1;
	free_desktop_object_list_names (data->self->priv->fdesktop_obj, mpris2_watcher_check_for_active_clients_ready, data);
	return FALSE;
	_state_1:
	data->_tmp1_ = NULL;
	data->_tmp1_ = free_desktop_object_list_names_finish (data->self->priv->fdesktop_obj, data->_res_, &data->_tmp0_, &data->_inner_error_);
	data->_tmp2_ = data->_tmp1_;
	data->_tmp2__length1 = data->_tmp0_;
	data->__tmp2__size_ = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			goto __catch7_g_io_error;
		}
		data->interfaces = (_vala_array_free (data->interfaces, data->interfaces_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->interfaces = (_vala_array_free (data->interfaces, data->interfaces_length1, (GDestroyNotify) g_free), NULL);
	data->interfaces = data->_tmp2_;
	data->interfaces_length1 = data->_tmp2__length1;
	data->_interfaces_size_ = data->_tmp2__length1;
	goto __finally7;
	__catch7_g_io_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("mpris2-watcher.vala:60: Mpris2watcher could fetch active interfaces at" \
" startup: %s", data->e->message);
		_g_error_free0 (data->e);
		data->interfaces = (_vala_array_free (data->interfaces, data->interfaces_length1, (GDestroyNotify) g_free), NULL);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally7:
	if (data->_inner_error_ != NULL) {
		data->interfaces = (_vala_array_free (data->interfaces, data->interfaces_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		data->address_collection = data->interfaces;
		data->address_collection_length1 = data->interfaces_length1;
		for (data->address_it = 0; data->address_it < data->interfaces_length1; data->address_it = data->address_it + 1) {
			data->_tmp3_ = g_strdup (data->address_collection[data->address_it]);
			data->address = data->_tmp3_;
			{
				data->_tmp4_ = g_str_has_prefix (data->address, MPRIS_PREFIX);
				if (data->_tmp4_) {
					data->_tmp5_ = NULL;
					data->_tmp5_ = mpris2_watcher_create_mpris_root (data->self, data->address);
					data->mpris2_root = data->_tmp5_;
					if (data->mpris2_root == NULL) {
						_g_object_unref0 (data->mpris2_root);
						_g_free0 (data->address);
						data->interfaces = (_vala_array_free (data->interfaces, data->interfaces_length1, (GDestroyNotify) g_free), NULL);
						if (data->_state_ == 0) {
							g_simple_async_result_complete_in_idle (data->_async_result);
						} else {
							g_simple_async_result_complete (data->_async_result);
						}
						g_object_unref (data->_async_result);
						return FALSE;
					}
					data->_tmp6_ = mpris2_watcher_supports_playlists (data->self, data->address);
					data->use_playlists = data->_tmp6_;
					data->_tmp7_ = NULL;
					data->_tmp7_ = mpris_root_get_DesktopEntry (data->mpris2_root);
					data->_tmp8_ = data->_tmp7_;
					g_signal_emit_by_name (data->self, "client-appeared", data->_tmp8_, data->address, data->use_playlists);
					_g_free0 (data->_tmp8_);
					_g_object_unref0 (data->mpris2_root);
				}
				_g_free0 (data->address);
			}
		}
	}
	data->interfaces = (_vala_array_free (data->interfaces, data->interfaces_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void mpris2_watcher_name_changes_detected (Mpris2Watcher* self, FreeDesktopObject* dbus_obj, const gchar* name, const gchar* previous_owner, const gchar* current_owner) {
	MprisRoot* _tmp0_ = NULL;
	MprisRoot* mpris2_root;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_obj != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (previous_owner != NULL);
	g_return_if_fail (current_owner != NULL);
	_tmp0_ = mpris2_watcher_create_mpris_root (self, name);
	mpris2_root = _tmp0_;
	if (mpris2_root == NULL) {
		_g_object_unref0 (mpris2_root);
		return;
	}
	if (g_strcmp0 (previous_owner, "") != 0) {
		_tmp1_ = g_strcmp0 (current_owner, "") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		g_debug ("mpris2-watcher.vala:84: Client '%s' gone down", name);
		g_signal_emit_by_name (self, "client-disappeared", name);
	} else {
		gboolean _tmp2_ = FALSE;
		if (g_strcmp0 (previous_owner, "") == 0) {
			_tmp2_ = g_strcmp0 (current_owner, "") != 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gboolean _tmp3_;
			gboolean use_playlists;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			g_debug ("mpris2-watcher.vala:88: Client '%s' has appeared", name);
			_tmp3_ = mpris2_watcher_supports_playlists (self, name);
			use_playlists = _tmp3_;
			_tmp4_ = mpris_root_get_DesktopEntry (mpris2_root);
			_tmp5_ = _tmp4_;
			g_signal_emit_by_name (self, "client-appeared", _tmp5_, name, use_playlists);
			_g_free0 (_tmp5_);
		}
	}
	_g_object_unref0 (mpris2_root);
}


static MprisRoot* mpris2_watcher_create_mpris_root (Mpris2Watcher* self, const gchar* name) {
	MprisRoot* result = NULL;
	MprisRoot* mpris2_root;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	mpris2_root = NULL;
	_tmp0_ = g_str_has_prefix (name, MPRIS_PREFIX);
	if (_tmp0_) {
		MprisRoot* _tmp1_ = NULL;
		MprisRoot* _tmp2_;
		_tmp1_ = g_initable_new (TYPE_MPRIS_ROOT_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", MPRIS_MEDIA_PLAYER_PATH, "g-interface-name", "org.mpris.MediaPlayer2", NULL);
		_tmp2_ = (MprisRoot*) _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch8_g_io_error;
			}
			_g_object_unref0 (mpris2_root);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (mpris2_root);
		mpris2_root = _tmp2_;
		goto __finally8;
		__catch8_g_io_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("mpris2-watcher.vala:103: Mpris2watcher could not create a root interfa" \
"ce: %s", e->message);
			_g_error_free0 (e);
		}
		__finally8:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (mpris2_root);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = mpris2_root;
	return result;
}


static gboolean mpris2_watcher_supports_playlists (Mpris2Watcher* self, const gchar* name) {
	gboolean result = FALSE;
	FreeDesktopIntrospectable* introspectable = NULL;
	FreeDesktopIntrospectable* _tmp0_ = NULL;
	FreeDesktopIntrospectable* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* results;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = g_initable_new (TYPE_FREE_DESKTOP_INTROSPECTABLE_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", name, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", MPRIS_MEDIA_PLAYER_PATH, "g-interface-name", "org.freedesktop.DBus.Introspectable", NULL);
	_tmp1_ = (FreeDesktopIntrospectable*) _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch9_g_io_error;
		}
		_g_object_unref0 (introspectable);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (introspectable);
	introspectable = _tmp1_;
	_tmp2_ = free_desktop_introspectable_Introspect (introspectable, &_inner_error_);
	results = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch9_g_io_error;
		}
		_g_object_unref0 (introspectable);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp3_ = mpris2_watcher_parse_interfaces (self, results);
	result = _tmp3_;
	_g_free0 (results);
	_g_object_unref0 (introspectable);
	return result;
	_g_free0 (results);
	goto __finally9;
	__catch9_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("mpris2-watcher.vala:131: Could not create an introspectable object: %s", e->message);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (introspectable);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	_g_object_unref0 (introspectable);
	return result;
}


static gboolean mpris2_watcher_parse_interfaces (Mpris2Watcher* self, const gchar* interface_info) {
	gboolean result = FALSE;
	gboolean _result_;
	xmlDoc* _tmp0_ = NULL;
	xmlDoc* xml_doc;
	xmlNode* _tmp1_ = NULL;
	xmlNode* root_node;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (interface_info != NULL, FALSE);
	_result_ = FALSE;
	_tmp0_ = xmlParseDoc (interface_info);
	xml_doc = _tmp0_;
	if (xml_doc == NULL) {
		g_warning ("mpris2-watcher.vala:143: Mpris2Watcher - parse-interfaces - failed to " \
"instantiate xml doc");
		result = FALSE;
		return result;
	}
	_tmp1_ = xmlDocGetRootElement (xml_doc);
	root_node = _tmp1_;
	if (root_node == NULL) {
		xmlFreeDoc (xml_doc);
		g_warning ("mpris2-watcher.vala:151: Mpris2Watcher - the interface info xml is emp" \
"ty");
		result = FALSE;
		return result;
	}
	{
		xmlNode* iter;
		iter = root_node->children;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				xmlAttr* attributes;
				gchar* _tmp3_;
				gchar* interface_name;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp2_) {
					iter = iter->next;
				}
				_tmp2_ = FALSE;
				if (!(iter != NULL)) {
					break;
				}
				if (iter->type != XML_ELEMENT_NODE) {
					continue;
				}
				attributes = iter->properties;
				_tmp3_ = g_strdup (attributes->children->content);
				interface_name = _tmp3_;
				g_debug ("mpris2-watcher.vala:163: this dbus object has interface %s ", interface_name);
				_tmp4_ = g_strconcat (MPRIS_PREFIX, "Playlists", NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strcmp0 (interface_name, _tmp5_) == 0;
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					_result_ = TRUE;
				}
				_g_free0 (interface_name);
			}
		}
	}
	xmlFreeDoc (xml_doc);
	result = _result_;
	return result;
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_BOOLEAN) (gpointer data1, const char* arg_1, const char* arg_2, gboolean arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_boolean (param_values + 3), data2);
}


static void _mpris2_watcher_name_changes_detected_free_desktop_object_name_owner_changed (FreeDesktopObject* _sender, const gchar* name, const gchar* old_owner, const gchar* new_owner, gpointer self) {
	mpris2_watcher_name_changes_detected (self, _sender, name, old_owner, new_owner);
}


static GObject * mpris2_watcher_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	Mpris2Watcher * self;
	FreeDesktopObject* _tmp0_ = NULL;
	FreeDesktopObject* _tmp1_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (mpris2_watcher_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MPRIS2_WATCHER (obj);
	_tmp0_ = g_initable_new (TYPE_FREE_DESKTOP_OBJECT_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES, "g-name", FREEDESKTOP_SERVICE, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", FREEDESKTOP_OBJECT, "g-interface-name", "org.freedesktop.DBus", NULL);
	_tmp1_ = (FreeDesktopObject*) _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch10_g_io_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_g_object_unref0 (self->priv->fdesktop_obj);
	self->priv->fdesktop_obj = _tmp1_;
	g_signal_connect_object (self->priv->fdesktop_obj, "name-owner-changed", (GCallback) _mpris2_watcher_name_changes_detected_free_desktop_object_name_owner_changed, self, 0);
	mpris2_watcher_check_for_active_clients (self, NULL, NULL);
	goto __finally10;
	__catch10_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("mpris2-watcher.vala:46: Mpris2watcher could not set up a watch for mpr" \
"is clients appearing on the bus: %s", e->message);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void mpris2_watcher_class_init (Mpris2WatcherClass * klass) {
	mpris2_watcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (Mpris2WatcherPrivate));
	G_OBJECT_CLASS (klass)->constructor = mpris2_watcher_constructor;
	G_OBJECT_CLASS (klass)->finalize = mpris2_watcher_finalize;
	g_signal_new ("client_appeared", TYPE_MPRIS2_WATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_BOOLEAN, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
	g_signal_new ("client_disappeared", TYPE_MPRIS2_WATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void mpris2_watcher_instance_init (Mpris2Watcher * self) {
	self->priv = MPRIS2_WATCHER_GET_PRIVATE (self);
}


static void mpris2_watcher_finalize (GObject* obj) {
	Mpris2Watcher * self;
	self = MPRIS2_WATCHER (obj);
	_g_object_unref0 (self->priv->fdesktop_obj);
	G_OBJECT_CLASS (mpris2_watcher_parent_class)->finalize (obj);
}


GType mpris2_watcher_get_type (void) {
	static volatile gsize mpris2_watcher_type_id__volatile = 0;
	if (g_once_init_enter (&mpris2_watcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (Mpris2WatcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mpris2_watcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mpris2Watcher), 0, (GInstanceInitFunc) mpris2_watcher_instance_init, NULL };
		GType mpris2_watcher_type_id;
		mpris2_watcher_type_id = g_type_register_static (G_TYPE_OBJECT, "Mpris2Watcher", &g_define_type_info, 0);
		g_once_init_leave (&mpris2_watcher_type_id__volatile, mpris2_watcher_type_id);
	}
	return mpris2_watcher_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



