/***************************************************************************
                          positionscreen.cpp  -  description
                             -------------------
    begin                : Sun Jan 20 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "positionscreen.h"

void PositionScreen::paintScreen(QPainter *pr, QWidget *rpt, setiparse *s, paintHelpers *ph) {
 	QPen light = QPen(ph->lgray,2);
	QPen dark  = QPen(ph->dgray,2);

	ph->clearScreen(pr);
  ph->drawMainHeader(pr,QString("Scanning position"));	
	pr->flush();

	double RA  =s->getWu_StartRa();
	double DEC =s->getWu_StartDec();
  buildCoordinates(RA, DEC);

	ph->drawSkymap(pr);	
	pr->flush();

	pr->setPen(QPen(ph->white,2));
	pr->drawLine(x,y-5,x,y+5);
	pr->drawLine(x-5,y,x+5,y);
	pr->setFont(ph->smallFont);

	pr->setPen(QPen(ph->lcarsOrange,2));
	pr->fillRect(0,580,1024,10,QBrush(ph->lcarsOrange));
	pr->drawLine(502,600,502,768);

	/*QString qtmp;
	qtmp.sprintf("DEC : %f",DEC);
	pr->drawText(x+30,y-10,qtmp,10);
	
	qtmp.sprintf("RA : %f deg",RA);
  pr->drawText(x+30,y+10,qtmp,10);
	*/


	/* Fix by  klesmen@t-online.de (Klemens Meyer) This makes sure, that the
   * RA/DEC diaply isn't cutted of by the edge of the screen */
  QString dectmp, ratmp;

	dectmp.sprintf("DEC : %f",DEC);
	ratmp.sprintf("RA : %f deg",RA);
	QRect	drect	= pr->boundingRect(0, 0, 1024, 768, QPainter::AlignLeft, dectmp, 10);
	QRect	rrect	= pr->boundingRect(0, 0, 1024, 768, QPainter::AlignLeft, ratmp, 10);
	if(x + 30 + drect.width() <= 1024 && x + 30 + rrect.width() < 1024)
	{
		pr->drawText(x+30,y-10,dectmp,10);
  	pr->drawText(x+30,y+10,ratmp,10);
  }
  else
  {
  	pr->drawText(x - 30 - drect.width(), y - 10, dectmp, 10);
  	pr->drawText(x - 30 - rrect.width(), y + 10, ratmp, 10);
  }
  /* end fix */

	pr->setFont(ph->mediumFont);
	for (int i = 0; i < 40; i++) {
		ph->skymapData(i,pr,s);
		if (i % 2 == 0) {
   		pr->setPen(dark);
		}
		else {
       pr->setPen(light);
		}
		pr->drawLine(x-20,y-20,x+13,y-20); //Oben
		pr->drawLine(x-20,y-20,x-20,y+13); //links
		pr->drawLine(x+20,y-13,x+20,y+20); //rechts
		pr->drawLine(x-13,y+20,x+20,y+20); //unten
		pr->flush();
		//rpt->repaint();
		usleep(400000);
	}
}

void PositionScreen::buildCoordinates(double RA, double DEC) {
	 x = (int)(484.0 - (RA*965.0)/24.0);
	 if (x < 0) x = 965 + x;
	 x+=30;

	 y =  (int)(241.0 - (DEC*482.0)/180.0);
	 y+=75;
}
