// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_BlockBuilder_HeaderFile
#define _BOP_BlockBuilder_HeaderFile

#ifndef _TColStd_DataMapOfIntegerInteger_HeaderFile
#include <TColStd_DataMapOfIntegerInteger.hxx>
#endif
#ifndef _TopTools_IndexedMapOfOrientedShape_HeaderFile
#include <TopTools_IndexedMapOfOrientedShape.hxx>
#endif
#ifndef _TColStd_SequenceOfInteger_HeaderFile
#include <TColStd_SequenceOfInteger.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class BOP_ShapeSet;
class BOP_BlockIterator;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  auxiliary class to storage and operate with data of <br>
//!  connexity blocks inside the given ShapeSet <br>
//! <br>
class BOP_BlockBuilder  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty  Constructor <br>
Standard_EXPORT BOP_BlockBuilder();


//! Create an  object for given ShapeSet <br>
Standard_EXPORT BOP_BlockBuilder(BOP_ShapeSet& SS);


//! Compute the set of connexity blocks of elements <br>
//! for of the ShapeSet SS <br>
//! <br>
//! <br>
//!   I t e r a t i o n   o n   b l o c k s made by MakeBlock <br>
//! <br>
Standard_EXPORT   void MakeBlock(BOP_ShapeSet& SS) ;


Standard_EXPORT   void InitBlock() ;


Standard_EXPORT   Standard_Boolean MoreBlock() const;


Standard_EXPORT   void NextBlock() ;


//! Returns the BlockIterator for the current block  . <br>
Standard_EXPORT   BOP_BlockIterator BlockIterator() const;


//! Returns the current element of <BI>. <br>
Standard_EXPORT  const TopoDS_Shape& Element(const BOP_BlockIterator& BI) const;


//! Returns the current element with index  <I> . <br>
Standard_EXPORT  const TopoDS_Shape& Element(const Standard_Integer I) const;


//! Returns the index of the current element . <br>
Standard_EXPORT   Standard_Integer Element(const TopoDS_Shape& S) const;


//! Internal <br>
Standard_EXPORT   Standard_Boolean ElementIsValid(const BOP_BlockIterator& BI) const;


//! Internal <br>
Standard_EXPORT   Standard_Boolean ElementIsValid(const Standard_Integer I) const;


//! Internal <br>
Standard_EXPORT   Standard_Integer AddElement(const TopoDS_Shape& S) ;


//! Internal <br>
Standard_EXPORT   void SetValid(const BOP_BlockIterator& BI,const Standard_Boolean IsValid) ;


//! Internal <br>
Standard_EXPORT   void SetValid(const Standard_Integer I,const Standard_Boolean IsValid) ;


//! Returns TRUE if all elements inside the current block <br>
//! are biconnexial <br>
Standard_EXPORT   Standard_Boolean CurrentBlockIsRegular() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TColStd_DataMapOfIntegerInteger myOrientedShapeMapIsValid;
TopTools_IndexedMapOfOrientedShape myOrientedShapeMap;
TColStd_SequenceOfInteger myBlocks;
Standard_Integer myBlockIndex;
Standard_Boolean myIsDone;
TColStd_SequenceOfInteger myBlocksIsRegular;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
