// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepBuilderAPI_Copy_HeaderFile
#define _BRepBuilderAPI_Copy_HeaderFile

#ifndef _BRepBuilderAPI_ModifyShape_HeaderFile
#include <BRepBuilderAPI_ModifyShape.hxx>
#endif
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Duplication of a shape. <br>
//! A Copy object provides a framework for: <br>
//! -   defining the construction of a duplicate shape, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the result. <br>
class BRepBuilderAPI_Copy  : public BRepBuilderAPI_ModifyShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs an empty copy framework. Use the function <br>
//! Perform to copy shapes. <br>
Standard_EXPORT BRepBuilderAPI_Copy();

//! Constructs a copy framework and copies the shape S. <br>
//! Use the function Shape to access the result. <br>
//! Note: the constructed framework can be reused to copy <br>
//! other shapes: just specify them with the function Perform. <br>
Standard_EXPORT BRepBuilderAPI_Copy(const TopoDS_Shape& S);

//! Copies the shape T. <br>
//! Use the function Shape to access the result. <br>
//! Note: this framework can be reused to copy other <br>
//! shapes: just specify them by calling the function Perform again. <br>
Standard_EXPORT   void Perform(const TopoDS_Shape& S) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
