// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepBuilderAPI_MakeShape_HeaderFile
#define _BRepBuilderAPI_MakeShape_HeaderFile

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
#ifndef _BRepBuilderAPI_Command_HeaderFile
#include <BRepBuilderAPI_Command.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class StdFail_NotDone;
class TopoDS_Shape;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This    is  the  root     class for     all  shape <br>
//!          constructions.  It stores the result. <br>
//! <br>
//!          It  provides deferred methods to trace the history <br>
//!          of sub-shapes. <br>
class BRepBuilderAPI_MakeShape  : public BRepBuilderAPI_Command {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT virtual  void Delete() ;
Standard_EXPORT virtual ~BRepBuilderAPI_MakeShape(){Delete() ; }

//! This is  called by  Shape().  It does  nothing but <br>
//!          may be redefined. <br>
Standard_EXPORT virtual  void Build() ;

//! Returns a shape built by the shape construction algorithm. <br>
//! Raises exception StdFail_NotDone if the shape was not built. <br>
Standard_EXPORT  const TopoDS_Shape& Shape() const;
Standard_EXPORT operator TopoDS_Shape() const;

//! Returns the  list   of shapes generated   from the <br>
//!          shape <S>. <br>
Standard_EXPORT virtual const TopTools_ListOfShape& Generated(const TopoDS_Shape& S) ;

//! Returns the list  of shapes modified from the shape <br>
//!          <S>. <br>
Standard_EXPORT virtual const TopTools_ListOfShape& Modified(const TopoDS_Shape& S) ;

//! Returns true if the shape S has been deleted. <br>
Standard_EXPORT virtual  Standard_Boolean IsDeleted(const TopoDS_Shape& S) ;





protected:

 // Methods PROTECTED
 // 


Standard_EXPORT BRepBuilderAPI_MakeShape();


 // Fields PROTECTED
 //
TopoDS_Shape myShape;
TopTools_ListOfShape myGenerated;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
