// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BinLDrivers_DocumentSection_HeaderFile
#define _BinLDrivers_DocumentSection_HeaderFile

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_Size_HeaderFile
#include <Standard_Size.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_IStream_HeaderFile
#include <Standard_IStream.hxx>
#endif
class TCollection_AsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! More or less independent part of the saved/restored document <br>
//!          that is distinct from OCAF data themselves but may be referred <br>
//!          by them. <br>
class BinLDrivers_DocumentSection  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Empty constructor <br>
Standard_EXPORT BinLDrivers_DocumentSection();

//! Constructor <br>
Standard_EXPORT BinLDrivers_DocumentSection(const TCollection_AsciiString& theName,const Standard_Boolean isPostRead);

//! Query the name of the section. <br>
Standard_EXPORT  const TCollection_AsciiString& Name() const;

//! Query the status: if the Section should be read after OCAF; <br>
//!          False means that the Section is read before starting to <br>
//!          read OCAF data. <br>
Standard_EXPORT   Standard_Boolean IsPostRead() const;

//! Query the offset of the section in the persistent file <br>
Standard_EXPORT   Standard_Size Offset() const;

//! Set the offset of the section in the persistent file <br>
Standard_EXPORT   void SetOffset(const Standard_Size theOffset) ;

//! Query the length of the section in the persistent file <br>
Standard_EXPORT   Standard_Size Length() const;

//! Set the length of the section in the persistent file <br>
Standard_EXPORT   void SetLength(const Standard_Size theLength) ;

//! Create a Section entry in the Document TOC (list of sections) <br>
Standard_EXPORT   void WriteTOC(Standard_OStream& theOS) ;

//! Save Offset and Length data into the Section entry <br>
//!          in the Document TOC (list of sections) <br>
Standard_EXPORT   void Write(Standard_OStream& theOS,const Standard_Size theOffset) ;

//! Fill a DocumentSection instance from the data that are read <br>
//!          from TOC. <br>
Standard_EXPORT static  void ReadTOC(BinLDrivers_DocumentSection& theSection,Standard_IStream& theIS) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TCollection_AsciiString myName;
Standard_Size myValue[2];
Standard_Boolean myIsPostRead;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
