// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BndLib_AddSurface_HeaderFile
#define _BndLib_AddSurface_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Adaptor3d_Surface;
class Bnd_Box;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! computes the box from a surface <br>
//! Functions to add a surface to a bounding box. <br>
//!  The surface is defined from a Geom surface. <br>
class BndLib_AddSurface  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Adds to the bounding box B the surface S <br>
//! B is then enlarged by the tolerance value Tol. <br>
//! Note: depending on the type of curve, one of the following <br>
//! representations of the surface S is used to include it in the bounding box B: <br>
//! -   an exact representation if S is built from a plane, a <br>
//!   cylinder, a cone, a sphere or a torus, <br>
//! -   the poles of the surface if S is built from a Bezier <br>
//!   surface or a BSpline surface, <br>
//! -   the points of an approximation of the surface S in <br>
//!   cases other than offset surfaces; <br>
//! -   in the case of an offset surface, the basis surface is first <br>
//!   included according to the previous rules; then the <br>
//!   bounding box is enlarged by the offset value. <br>
//!   Warning <br>
//! Do not use these functions to add a non-finite surface to <br>
//! the bounding box B. <br>
//! If UMin, UMax, VMin or VMax is an infinite value B will become WholeSpace. <br>
//! S is an adapted surface, that is, an object which is an interface between: <br>
//! -   the services provided by a surface from the package Geom <br>
//! -   and those required of the surface by the computation algorithm. <br>
//!   The adapted surface is created in the following way: <br>
//!    Handle(Geom_Surface) mysurface = ... ; <br>
//!    GeomAdaptor_Surface S(mysurface); <br>
//! The bounding box B is then enlarged by adding this surface: <br>
//!    Bnd_Box B; <br>
//! // ... <br>
//!    Standard_Real Tol = ... ; <br>
//!    AddSurface::Add ( S, Tol, B ); <br>
Standard_EXPORT static  void Add(const Adaptor3d_Surface& S,const Standard_Real Tol,Bnd_Box& B) ;

//! Adds to the bounding box B the surface S <br>
//! the patch of the surface S limited in the u parametric <br>
//!   direction by the two parameter values UMin, UMax, and <br>
//!   in the v parametric direction by the two parameter <br>
//!   values VMin, VMax. <br>
//! Note: depending on the type of curve, one of the following <br>
//! representations of the surface S is used to include it in the bounding box B: <br>
//! -   an exact representation if S is built from a plane, a <br>
//!   cylinder, a cone, a sphere or a torus, <br>
//! -   the poles of the surface if S is built from a Bezier <br>
//!   surface or a BSpline surface, <br>
//! -   the points of an approximation of the surface S in <br>
//!   cases other than offset surfaces; <br>
//! -   in the case of an offset surface, the basis surface is first <br>
//!   included according to the previous rules; then the <br>
//!   bounding box is enlarged by the offset value. <br>
//!   Warning <br>
//! Do not use these functions to add a non-finite surface to <br>
//! the bounding box B. <br>
//! If UMin, UMax, VMin or VMax is an infinite value B will become WholeSpace. <br>
//! S is an adapted surface, that is, an object which is an interface between: <br>
//! -   the services provided by a surface from the package Geom <br>
//! -   and those required of the surface by the computation algorithm. <br>
//!   The adapted surface is created in the following way: <br>
//!    Handle(Geom_Surface) mysurface = ... ; <br>
//!    GeomAdaptor_Surface S(mysurface); <br>
//! The bounding box B is then enlarged by adding this surface: <br>
//!    Bnd_Box B; <br>
//! // ... <br>
//!    Standard_Real Tol = ... ; <br>
//!    AddSurface::Add ( S, Tol, B ); <br>
Standard_EXPORT static  void Add(const Adaptor3d_Surface& S,const Standard_Real UMin,const Standard_Real UMax,const Standard_Real VMin,const Standard_Real VMax,const Standard_Real Tol,Bnd_Box& B) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
