// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Convert_HyperbolaToBSplineCurve_HeaderFile
#define _Convert_HyperbolaToBSplineCurve_HeaderFile

#ifndef _Convert_ConicToBSplineCurve_HeaderFile
#include <Convert_ConicToBSplineCurve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class gp_Hypr2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  This algorithm converts a hyperbola into a rational B-spline curve. <br>
//!  The hyperbola is an Hypr2d from package gp with the <br>
//!  parametrization : <br>
//!  P (U) = <br>
//!  Loc + (MajorRadius * Cosh(U) * Xdir + MinorRadius * Sinh(U) * Ydir) <br>
//!  where Loc is the location point of the hyperbola, Xdir and Ydir are <br>
//!  the normalized directions of the local cartesian coordinate system <br>
//!  of the hyperbola. <br>
//! KeyWords : <br>
//!  Convert, Hyperbola, BSplineCurve, 2D . <br>
class Convert_HyperbolaToBSplineCurve  : public Convert_ConicToBSplineCurve {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//!  The hyperbola H is limited between the parametric values U1, U2 <br>
//!  and the equivalent B-spline curve has the same orientation as the <br>
//!  hyperbola. <br>
Standard_EXPORT Convert_HyperbolaToBSplineCurve(const gp_Hypr2d& H,const Standard_Real U1,const Standard_Real U2);





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
