// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomAPI_ExtremaSurfaceSurface_HeaderFile
#define _GeomAPI_ExtremaSurfaceSurface_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Extrema_ExtSS_HeaderFile
#include <Extrema_ExtSS.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Quantity_Parameter_HeaderFile
#include <Quantity_Parameter.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
class Standard_OutOfRange;
class StdFail_NotDone;
class Geom_Surface;
class gp_Pnt;
class Extrema_ExtSS;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions for computing all the extrema <br>
//! between two surfaces. <br>
//! An ExtremaSurfaceSurface algorithm minimizes or <br>
//! maximizes the distance between a point on the first <br>
//! surface and a point on the second surface. Results <br>
//! are start and end points of perpendiculars common to the two surfaces. <br>
//! Solutions consist of pairs of points, and an extremum <br>
//! is considered to be a segment joining the two points of a solution. <br>
//! An ExtremaSurfaceSurface object provides a framework for: <br>
//! -   defining the construction of the extrema, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the results. <br>
//! Warning <br>
//! In some cases, the nearest points between the two <br>
//! surfaces do not correspond to one of the computed <br>
//! extrema. Instead, they may be given by: <br>
//! -   a point of a bounding curve of one surface and one of the following: <br>
//!   -   its orthogonal projection on the other surface, <br>
//!   -   a point of a bounding curve of the other surface; or <br>
//! -   any point on intersection curves between the two surfaces. <br>
class GeomAPI_ExtremaSurfaceSurface  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs an empty algorithm for computing <br>
//! extrema between two surfaces. Use an Init function <br>
//! to define the surfaces on which it is going to work. <br>
Standard_EXPORT GeomAPI_ExtremaSurfaceSurface();

//! Computes  the  extrema  distances  between  the <br>
//!          surfaces <S1>  and <S2> <br>
Standard_EXPORT GeomAPI_ExtremaSurfaceSurface(const Handle(Geom_Surface)& S1,const Handle(Geom_Surface)& S2);

//! Computes  the  extrema  distances  between <br>
//!   the portion of the surface S1 limited by the <br>
//!  two values of parameter (U1min,U1max) in <br>
//!    the u parametric direction, and by the two <br>
//!    values of parameter (V1min,V1max) in the v <br>
//!    parametric direction, and <br>
//!   -   the portion of the surface S2 limited by the <br>
//!    two values of parameter (U2min,U2max) in <br>
//!    the u parametric direction, and by the two <br>
//!    values of parameter (V2min,V2max) in the v <br>
//!    parametric direction. <br>
Standard_EXPORT GeomAPI_ExtremaSurfaceSurface(const Handle(Geom_Surface)& S1,const Handle(Geom_Surface)& S2,const Quantity_Parameter U1min,const Quantity_Parameter U1max,const Quantity_Parameter V1min,const Quantity_Parameter V1max,const Quantity_Parameter U2min,const Quantity_Parameter U2max,const Quantity_Parameter V2min,const Quantity_Parameter V2max);

//! Initializes this algorithm with the given arguments <br>
//!        and computes  the  extrema  distances  between  the <br>
//!          surfaces <S1>  and <S2> <br>
Standard_EXPORT   void Init(const Handle(Geom_Surface)& S1,const Handle(Geom_Surface)& S2) ;

//! Initializes this algorithm with the given arguments <br>
//!        and computes  the  extrema  distances  between - <br>
//! the portion of the surface S1 limited by the two <br>
//!    values of parameter (U1min,U1max) in the u <br>
//!    parametric direction, and by the two values of <br>
//!    parameter (V1min,V1max) in the v parametric direction, and <br>
//!   -   the portion of the surface S2 limited by the two <br>
//!    values of parameter (U2min,U2max) in the u <br>
//!    parametric direction, and by the two values of <br>
//!    parameter (V2min,V2max) in the v parametric direction. <br>
Standard_EXPORT   void Init(const Handle(Geom_Surface)& S1,const Handle(Geom_Surface)& S2,const Quantity_Parameter U1min,const Quantity_Parameter U1max,const Quantity_Parameter V1min,const Quantity_Parameter V1max,const Quantity_Parameter U2min,const Quantity_Parameter U2max,const Quantity_Parameter V2min,const Quantity_Parameter V2max) ;

//! Returns the number of extrema computed by this algorithm. <br>
//! Note: if this algorithm fails, NbExtrema returns 0. <br>
Standard_EXPORT   Standard_Integer NbExtrema() const;
Standard_EXPORT operator Standard_Integer() const;

//! Returns the points P1 on the first surface and P2 on <br>
//! the second surface, which are the ends of the <br>
//! extremum of index Index computed by this algorithm. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ <br>
//! 1,NbExtrema ], where NbExtrema is the <br>
//! number of extrema computed by this algorithm. <br>
Standard_EXPORT   void Points(const Standard_Integer Index,gp_Pnt& P1,gp_Pnt& P2) const;

//! Returns the parameters (U1,V1) of the point on the <br>
//! first surface, and (U2,V2) of the point on the second <br>
//! surface, which are the ends of the extremum of index <br>
//! Index computed by this algorithm. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ <br>
//! 1,NbExtrema ], where NbExtrema is the <br>
//! number of extrema computed by this algorithm. <br>
Standard_EXPORT   void Parameters(const Standard_Integer Index,Quantity_Parameter& U1,Quantity_Parameter& V1,Quantity_Parameter& U2,Quantity_Parameter& V2) const;

//! Computes the distance between the end points of the <br>
//! extremum of index Index computed by this algorithm. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ <br>
//! 1,NbExtrema ], where NbExtrema is the <br>
//! number of extrema computed by this algorithm. <br>
Standard_EXPORT   Quantity_Length Distance(const Standard_Integer Index) const;

//! Returns the points P1 on the first surface and P2 on <br>
//! the second surface, which are the ends of the <br>
//! shortest extremum computed by this algorithm. <br>
//! Exceptions StdFail_NotDone if this algorithm fails. <br>
Standard_EXPORT   void NearestPoints(gp_Pnt& P1,gp_Pnt& P2) const;

//! Returns the parameters (U1,V1) of the point on the <br>
//! first surface and (U2,V2) of the point on the second <br>
//! surface, which are the ends of the shortest extremum <br>
//! computed by this algorithm. <br>
//! Exceptions - StdFail_NotDone if this algorithm fails. <br>
Standard_EXPORT   void LowerDistanceParameters(Quantity_Parameter& U1,Quantity_Parameter& V1,Quantity_Parameter& U2,Quantity_Parameter& V2) const;

//! Computes the distance between the end points of the <br>
//! shortest extremum computed by this algorithm. <br>
//! Exceptions StdFail_NotDone if this algorithm fails. <br>
Standard_EXPORT   Quantity_Length LowerDistance() const;
Standard_EXPORT operator Standard_Real() const;
//! return the algorithmic object from Extrema <br>
 const Extrema_ExtSS& Extrema() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myIsDone;
Standard_Integer myIndex;
Extrema_ExtSS myExtSS;


};


#include <GeomAPI_ExtremaSurfaceSurface.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
