// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Interface_InterfaceModel_HeaderFile
#define _Interface_InterfaceModel_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif

#ifndef _TColStd_IndexedMapOfTransient_HeaderFile
#include <TColStd_IndexedMapOfTransient.hxx>
#endif
#ifndef _Interface_DataMapOfIntegerTransient_HeaderFile
#include <Interface_DataMapOfIntegerTransient.hxx>
#endif
#ifndef _Handle_Interface_Check_HeaderFile
#include <Handle_Interface_Check.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Handle_Interface_GTool_HeaderFile
#include <Handle_Interface_GTool.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Standard_Type_HeaderFile
#include <Handle_Standard_Type.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Interface_DataState_HeaderFile
#include <Interface_DataState.hxx>
#endif
#ifndef _Handle_Interface_ReportEntity_HeaderFile
#include <Handle_Interface_ReportEntity.hxx>
#endif
#ifndef _Handle_Message_Messenger_HeaderFile
#include <Handle_Message_Messenger.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfHAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#endif
class Interface_Check;
class TCollection_HAsciiString;
class Interface_GTool;
class Standard_OutOfRange;
class Standard_NoSuchObject;
class Interface_InterfaceMismatch;
class Interface_Protocol;
class Standard_Transient;
class Standard_Type;
class Interface_ReportEntity;
class Interface_CheckIterator;
class Interface_GeneralLib;
class Interface_EntityIterator;
class Message_Messenger;
class TColStd_HSequenceOfHAsciiString;


//! Defines an (Indexed) Set of data corresponding to a complete <br>
//!           Transfer by a File Interface, i.e. File Header and Transient <br>
//!           Entities (Objects) contained in a File. Contained Entities are <br>
//!           identified in the Model by unique and consecutive Numbers. <br>
//! <br>
//!           In addition, a Model can attach to each entity, a specific <br>
//!           Label according to the norm (e.g. Name for VDA, #ident for <br>
//!           Step ...), intended to be output on a string or a stream <br>
//!           (remark : labels are not obliged to be unique) <br>
//! <br>
//!           InterfaceModel itself is not Transient, it is intended to <br>
//!           work on a set of Transient Data. The services offered are <br>
//!           basic Listing and Identification operations on Transient <br>
//!           Entities, storage of Error Reports, Copying. <br>
//! <br>
//!           Moreovere, it is possible to define and use templates. These <br>
//!           are empty Models, from which copies can be obtained in order <br>
//!           to be filled with effective data. This allows to record <br>
//!           standard definitions for headers, avoiding to recreate them <br>
//!           for each sendings, and assuring customisation of produced <br>
//!           files for a given site. <br>
//!           A template is attached to a name. It is possible to define a <br>
//!           template from another one (get it, edit it then record it <br>
//!           under another name). <br>
//! <br>
//!           See also Graph, ShareTool, CheckTool for more <br>
class Interface_InterfaceModel : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Clears the list of entities (service WhenDelete) <br>
Standard_EXPORT   void Destroy() ;
~Interface_InterfaceModel()
{
  Destroy();
}


//! Sets a Protocol for this Model <br>
//!           It is also set by a call to AddWithRefs with Protocol <br>
//!           It is used for : DumpHeader (as required), ClearEntities ... <br>
Standard_EXPORT   void SetProtocol(const Handle(Interface_Protocol)& proto) ;

//! Returns the Protocol which has been set by SetProtocol, or <br>
//!           AddWithRefs with Protocol <br>
Standard_EXPORT virtual  Handle_Interface_Protocol Protocol() const;

//! Sets a GTool for this model, which already defines a Protocol <br>
Standard_EXPORT   void SetGTool(const Handle(Interface_GTool)& gtool) ;

//! Returns the GTool, set by SetProtocol or by SetGTool <br>
Standard_EXPORT   Handle_Interface_GTool GTool() const;

//! Returns the Dispatch Status, either for get or set <br>
//!           A Model which is produced from Dispatch may share entities <br>
//!           with the original (according to the Protocol), hence these <br>
//!           non-copied entities should not be deleted <br>
Standard_EXPORT   Standard_Boolean& DispatchStatus() ;

//! Erases contained data; used when a Model is copied to others : <br>
//!           the new copied ones begin from clear <br>
//!           Clear calls specific method ClearHeader (see below) <br>
Standard_EXPORT virtual  void Clear() ;

//! Clears the entities; uses the general service WhenDelete, in <br>
//!           addition to the standard Memory Manager; can be redefined <br>
Standard_EXPORT virtual  void ClearEntities() ;

//! Erases informations about labels, if any : specific to each <br>
//!           norm <br>
Standard_EXPORT virtual  void ClearLabels()  = 0;

//! Clears Model's header : specific to each norm <br>
Standard_EXPORT virtual  void ClearHeader()  = 0;

//! Returns count of contained Entities <br>
Standard_EXPORT   Standard_Integer NbEntities() const;

//! Returns True if a Model contains an Entity (for a ReportEntity, <br>
//!           looks for the ReportEntity itself AND its Concerned Entity) <br>
Standard_EXPORT   Standard_Boolean Contains(const Handle(Standard_Transient)& anentity) const;

//! Returns the Number of an Entity in the Model if it contains it. <br>
//!           Else returns 0. For a ReportEntity, looks at Concerned Entity. <br>//!  Returns the Directory entry   Number of  an Entity in <br>
//!         the  Model if it contains it.   Else returns  0.  For a <br>
//!         ReportEntity, looks at Concerned Entity. <br>
Standard_EXPORT   Standard_Integer Number(const Handle(Standard_Transient)& anentity) const;

//! Returns an Entity identified by its number in the Model <br>
//!           Each sub-class of InterfaceModel can define its own method <br>
//!           Entity to return its specific class of Entity (e.g. for VDA, <br>
//!           VDAModel returns a VDAEntity), working by calling Value <br>
//! Remark : For a Reported Entity, (Erroneous, Corrected, Unknown), this <br>
//! 	        method returns this Reported Entity. <br>
//!          See ReportEntity for other questions. <br>
Standard_EXPORT  const Handle_Standard_Transient& Value(const Standard_Integer num) const;

//! Returns the count of DISTINCT types under which an entity may <br>
//!           be processed. Defined by the Protocol, which gives default as <br>
//!           1 (dynamic Type). <br>
Standard_EXPORT   Standard_Integer NbTypes(const Handle(Standard_Transient)& ent) const;

//! Returns a type, given its rank : defined by the Protocol <br>
//!           (by default, the first one) <br>
Standard_EXPORT   Handle_Standard_Type Type(const Handle(Standard_Transient)& ent,const Standard_Integer num = 1) const;

//! Returns the type name of an entity, from the list of types <br>
//!           (one or more ...) <br>
//!           <complete> True (D) gives the complete type, else packages are <br>
//!             removed <br>
//!           WARNING : buffered, to be immediately copied or printed <br>
Standard_EXPORT   Standard_CString TypeName(const Handle(Standard_Transient)& ent,const Standard_Boolean complete = Standard_True) const;

//! From a CDL Type Name, returns the Class part (package dropped) <br>
//!           WARNING : buffered, to be immediately copied or printed <br>
Standard_EXPORT static  Standard_CString ClassName(const Standard_CString typnam) ;

//! Returns the State of an entity, given its number <br>
Standard_EXPORT   Interface_DataState EntityState(const Standard_Integer num) const;

//! Returns True if <num> identifies a ReportEntity in the Model <br>
//!           Hence, ReportEntity can be called. <br>
//! <br>
//!           By default, queries main report, if <semantic> is True, it <br>
//!           queries report for semantic check <br>
//! <br>
//!           Remember that a Report Entity can be defined for an Unknown <br>
//!           Entity, or a Corrected or Erroneous (at read time) Entity. <br>
//!           The ReportEntity is defined before call to method AddEntity. <br>
Standard_EXPORT   Standard_Boolean IsReportEntity(const Standard_Integer num,const Standard_Boolean semantic = Standard_False) const;

//! Returns a ReportEntity identified by its number in the Model, <br>
//!           or a Null Handle If <num> does not identify a ReportEntity. <br>
//! <br>
//!           By default, queries main report, if <semantic> is True, it <br>
//!           queries report for semantic check <br>
Standard_EXPORT   Handle_Interface_ReportEntity ReportEntity(const Standard_Integer num,const Standard_Boolean semantic = Standard_False) const;

//! Returns True if <num> identifies an Error Entity : in this <br>
//!           case, a ReportEntity brings Fail Messages and possibly an <br>
//!           "undefined" Content, see IsRedefinedEntity <br>
Standard_EXPORT   Standard_Boolean IsErrorEntity(const Standard_Integer num) const;

//! Returns True if <num> identifies an Entity which content is <br>
//!           redefined through a ReportEntity (i.e. with literal data only) <br>
//!           This happens when an entity is syntactically erroneous in the <br>
//!           way that its basic content remains empty. <br>
//!           For more details (such as content itself), see ReportEntity <br>
Standard_EXPORT   Standard_Boolean IsRedefinedContent(const Standard_Integer num) const;

//! Removes the ReportEntity attached to Entity <num>. Returns <br>
//!           True if done, False if no ReportEntity was attached to <num>. <br>
//!  Warning : the caller must assume that this clearing is meaningfull <br>
Standard_EXPORT   Standard_Boolean ClearReportEntity(const Standard_Integer num) ;

//! Sets or Replaces a ReportEntity for the Entity <num>. Returns <br>
//!           True if Report is replaced, False if it has been replaced <br>
//!  Warning : the caller must assume that this setting is meaningfull <br>
Standard_EXPORT   Standard_Boolean SetReportEntity(const Standard_Integer num,const Handle(Interface_ReportEntity)& rep) ;

//! Adds a ReportEntity as such. Returns False if the concerned <br>
//!           entity is not recorded in the Model <br>
//!           Else, adds it into, either the main report list or the <br>
//!           list for semantic checks, then returns True <br>
Standard_EXPORT   Standard_Boolean AddReportEntity(const Handle(Interface_ReportEntity)& rep,const Standard_Boolean semantic = Standard_False) ;

//! Returns True if <num> identifies an Unknown Entity : in this <br>
//!           case, a ReportEntity with no Check Messages designates it. <br>
Standard_EXPORT   Standard_Boolean IsUnknownEntity(const Standard_Integer num) const;

//! Fills the list of semantic checks. <br>
//!           This list is computed (by CheckTool). Hence, it can be stored <br>
//!           in the model for later queries <br>
//!           <clear> True (D) : new list replaces <br>
//!           <clear> False    : new list is cumulated <br>
Standard_EXPORT   void FillSemanticChecks(const Interface_CheckIterator& checks,const Standard_Boolean clear = Standard_True) ;

//! Returns True if semantic checks have been filled <br>
Standard_EXPORT   Standard_Boolean HasSemanticChecks() const;

//! Returns the check attached to an entity, designated by its <br>
//!           Number. 0 for global check <br>
//!           <semantic> True  : recorded semantic check <br>
//!           <semantic> False : recorded syntactic check (see ReportEntity) <br>
//!           If no check is recorded for <num>, returns an empty Check <br>
Standard_EXPORT  const Handle_Interface_Check& Check(const Standard_Integer num,const Standard_Boolean syntactic) const;

//! Does a reservation for the List of Entities (for optimized <br>
//!           storage management). If it is not called, storage management <br>
//!           can be less efficient. <nbent> is the expected count of <br>
//!           Entities to store <br>
Standard_EXPORT virtual  void Reservate(const Standard_Integer nbent) ;

//! Internal method for adding an Entity. Used by file reading <br>
//!           (defined by each Interface) and Transfer tools. It adds the <br>
//!           entity required to be added, not its refs : see AddWithRefs. <br>
//!           If <anentity> is a ReportEntity, it is added to the list of <br>
//!           Reports, its Concerned Entity (Erroneous or Corrected, else <br>
//!           Unknown) is added to the list of Entities. <br>
//!           That is, the ReportEntity must be created before Adding <br>
Standard_EXPORT virtual  void AddEntity(const Handle(Standard_Transient)& anentity) ;

//! Adds to the Model, an Entity with all its References, as they <br>
//!           are defined by General Services FillShared and ListImplied. <br>
//!           Process is recursive (any sub-levels) if <level> = 0 (Default) <br>
//!           Else, adds sub-entities until the required sub-level. <br>
//!           Especially, if <level> = 1, adds immediate subs and that's all <br>
//! <br>
//!           If <listall> is False (Default), an entity (<anentity> itself <br>
//!           or one of its subs at any level) which is already recorded in <br>
//!           the Model is not analysed, only the newly added ones are. <br>
//!           If <listall> is True, all items are analysed (this allows to <br>
//!           ensure the consistency of an adding made by steps) <br>
Standard_EXPORT   void AddWithRefs(const Handle(Standard_Transient)& anent,const Handle(Interface_Protocol)& proto,const Standard_Integer level = 0,const Standard_Boolean listall = Standard_False) ;

//! Same as above, but works with the Protocol of the Model <br>
Standard_EXPORT   void AddWithRefs(const Handle(Standard_Transient)& anent,const Standard_Integer level = 0,const Standard_Boolean listall = Standard_False) ;

//! Same as above, but works with an already created GeneralLib <br>
Standard_EXPORT   void AddWithRefs(const Handle(Standard_Transient)& anent,const Interface_GeneralLib& lib,const Standard_Integer level = 0,const Standard_Boolean listall = Standard_False) ;

//! Replace Entity with Number=nument on other entity - "anent" <br>
Standard_EXPORT   void ReplaceEntity(const Standard_Integer nument,const Handle(Standard_Transient)& anent) ;

//! Reverses the Numbers of the Entities, between <after> and the <br>
//!           total count of Entities. Thus, the entities : <br>
//!           1,2 ... after, after+1 ... nb-1, nb  become numbered as : <br>
//!           1,2 ... after, nb, nb-1 ... after+1 <br>
//!           By default (after = 0) the whole list of Entities is reversed <br>
Standard_EXPORT   void ReverseOrders(const Standard_Integer after = 0) ;

//! Changes the Numbers of some Entities : <oldnum> is moved to <br>
//!           <newnum>, same for <count> entities. Thus : <br>
//!           1,2 ... newnum-1 newnum ... oldnum .. oldnum+count oldnum+count+1 .. gives <br>
//!           1,2 ... newnum-1 oldnum .. oldnum+count newnum ... oldnum+count+1 <br>
//!           (can be seen as a circular permutation) <br>
Standard_EXPORT   void ChangeOrder(const Standard_Integer oldnum,const Standard_Integer newnum,const Standard_Integer count = 1) ;

//! Gets contents from an EntityIterator, prepared by a <br>
//!           Transfer tool (e.g TransferCopy). Starts from clear <br>
Standard_EXPORT   void GetFromTransfer(const Interface_EntityIterator& aniter) ;

//! Gets header (data specific of a defined Interface) from <br>
//!           another InterfaceModel; called from TransferCopy <br>
Standard_EXPORT virtual  void GetFromAnother(const Handle(Interface_InterfaceModel)& other)  = 0;

//! Returns a New Empty Model, same type as <me> (whatever its <br>
//!           Type); called to Copy parts a Model into other ones, then <br>
//!           followed by a call to GetFromAnother (Header) then filling <br>
//!           with specified Entities, themselves copied <br>
Standard_EXPORT virtual  Handle_Interface_InterfaceModel NewEmptyModel() const = 0;

//! Records a category number for an entity number <br>
//!           Returns True when done, False if <num> is out of range <br>
Standard_EXPORT   Standard_Boolean SetCategoryNumber(const Standard_Integer num,const Standard_Integer val) ;

//! Returns the recorded category number for a given entity number <br>
//!           0 if none was defined for this entity <br>
Standard_EXPORT   Standard_Integer CategoryNumber(const Standard_Integer num) const;

//! Allows an EntityIterator to get a list of Entities <br>
Standard_EXPORT   void FillIterator(Interface_EntityIterator& iter) const;

//! Returns the list of all Entities, as an Iterator on Entities <br>
//!           (the Entities themselves, not the Reports) <br>
Standard_EXPORT   Interface_EntityIterator Entities() const;

//! Returns the list of all ReportEntities, i.e. data about <br>
//!           Entities read with Error or Warning informations <br>
//!           (each item has to be casted to Report Entity then it can be <br>
//!           queried for Concerned Entity, Content, Check ...) <br>
//!           By default, returns the main reports, is <semantic> is True it <br>
//!           returns the list for sematic checks <br>
Standard_EXPORT   Interface_EntityIterator Reports(const Standard_Boolean semantic = Standard_False) const;

//! Returns the list of ReportEntities which redefine data <br>
//!           (generally, if concerned entity is "Error", a literal content <br>
//!           is added to it : this is a "redefined entity" <br>
Standard_EXPORT   Interface_EntityIterator Redefineds() const;

//! Returns the GlobalCheck, which memorizes messages global to <br>
//!           the file (not specific to an Entity), especially Header <br>
Standard_EXPORT  const Handle_Interface_Check& GlobalCheck(const Standard_Boolean syntactic = Standard_True) const;

//! Allows to modify GlobalCheck, after getting then completing it <br>
//!           Remark : it is SYNTACTIC check. Semantics, see FillChecks <br>
Standard_EXPORT   void SetGlobalCheck(const Handle(Interface_Check)& ach) ;

//! Minimum Semantic Global Check on data in model (header) <br>
//!           Can only check basic Data. See also GlobalCheck from Protocol <br>
//!           for a check which takes the Graph into account <br>
//!           Default does nothing, can be redefined <br>
Standard_EXPORT virtual  void VerifyCheck(Handle(Interface_Check)& ach) const;

//! Dumps Header in a short, easy to read, form, onto a Stream <br>
//!           <level> allows to print more or less parts of the header, <br>
//!           if necessary. 0 for basic print <br>
Standard_EXPORT virtual  void DumpHeader(const Handle(Message_Messenger)& S,const Standard_Integer level = 0) const = 0;

//! Prints identification of a given entity in <me>, in order to <br>
//!           be printed in a list or phrase <br>
//!           <mode> < 0 : prints only its number <br>
//!           <mode> = 1 : just calls PrintLabel <br>
//!           <mode> = 0 (D) : prints its number plus '/' plus PrintLabel <br>
//!           If <ent> == <me>, simply prints "Global" <br>
//!           If <ent> is unknown, prints "??/its type" <br>
Standard_EXPORT   void Print(const Handle(Standard_Transient)& ent,const Handle(Message_Messenger)& s,const Standard_Integer mode = 0) const;

//! Prints label specific to each norm, for a given entity. <br>
//!           Must only print label itself, in order to be included in a <br>
//!           phrase. Can call the result of StringLabel, but not obliged. <br>
Standard_EXPORT virtual  void PrintLabel(const Handle(Standard_Transient)& ent,const Handle(Message_Messenger)& S) const = 0;

//! Prints label specific to each norm in log format, for <br>
//!         a given entity. <br>
//!         By default, just calls PrintLabel, can be redefined <br>
Standard_EXPORT virtual  void PrintToLog(const Handle(Standard_Transient)& ent,const Handle(Message_Messenger)& S) const;

//! Returns a string with the label attached to a given entity. <br>
//!  Warning : While this string may be edited on the spot, if it is a read <br>
//!           field, the returned value must be copied before. <br>
Standard_EXPORT virtual  Handle_TCollection_HAsciiString StringLabel(const Handle(Standard_Transient)& ent) const = 0;

//! Searches a label which matches with one entity. <br>
//!           Begins from <lastnum>+1 (default:1) and scans the entities <br>
//!           until <NbEntities>. For the first which matches <label>, <br>
//!           this method returns its Number. Returns 0 if nothing found <br>
//!           Can be called recursively (labels are not specified as unique) <br>
//!           <exact> : if True (default), exact match is required <br>
//!           else, checks the END of entity label <br>
//! <br>
//!           This method is virtual, hence it can be redefined for a more <br>
//!           efficient search (if exact is true). <br>
Standard_EXPORT virtual  Standard_Integer NextNumberForLabel(const Standard_CString label,const Standard_Integer lastnum = 0,const Standard_Boolean exact = Standard_True) const;

//! Returns true if a template is attached to a given name <br>
Standard_EXPORT static  Standard_Boolean HasTemplate(const Standard_CString name) ;

//! Returns the template model attached to a name, or a Null Handle <br>
Standard_EXPORT static  Handle_Interface_InterfaceModel Template(const Standard_CString name) ;

//! Records a new template model with a name. If the name was <br>
//!           already recorded, the corresponding template is replaced by <br>
//!           the new one. Then, WARNING : test HasTemplate to avoid <br>
//!           surprises <br>
Standard_EXPORT static  Standard_Boolean SetTemplate(const Standard_CString name,const Handle(Interface_InterfaceModel)& model) ;

//! Returns the complete list of names attached to template models <br>
Standard_EXPORT static  Handle_TColStd_HSequenceOfHAsciiString ListTemplates() ;




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Defines empty InterfaceModel, ready to be filled <br>
Standard_EXPORT Interface_InterfaceModel();


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TColStd_IndexedMapOfTransient theentities;
Interface_DataMapOfIntegerTransient thereports;
Interface_DataMapOfIntegerTransient therepch;
Handle_Interface_Check thecheckstx;
Handle_Interface_Check thechecksem;
Standard_Boolean haschecksem;
Standard_Boolean isdispatch;
Handle_TCollection_HAsciiString thecategory;
Handle_Interface_GTool thegtool;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
