// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Materials_HeaderFile
#define _Materials_HeaderFile

#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_Materials_MaterialsDictionary_HeaderFile
#include <Handle_Materials_MaterialsDictionary.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Materials_Material_HeaderFile
#include <Handle_Materials_Material.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Materials_MaterialsDictionary;
class Materials_Material;
class Materials_Color;
class Materials_MaterialDefinition;
class Materials_MaterialsDictionary;
class Materials_FuzzyInstance;
class Materials_Material;
class Materials_MtsSequence;
class Materials_MaterialsSequence;
class Materials_SequenceNodeOfMtsSequence;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This package is useful  for creating Material objects, <br>
//!          which contain a sequence of  physical properties.  All <br>
//!          applications  which  request physical properties  on a <br>
//!          given material, should reference this package. <br>
//! <br>
//!          A predefined sequence  of materials  is given  by  the <br>
//!          dictionary of  materials, and  the sequence   of known <br>
//!          properties is given by the material definition. <br>
//! <br>
//!          Only the  package  methods   are public,   except  the <br>
//!          DictionaryOfMaterials class which   is called  by  the <br>
//!          method Material. <br>
class Materials  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Sets the  location and the name  of the  file defining <br>
//!          the definition of a material, in term of properties. <br>
Standard_EXPORT static  void MaterialFile(const Standard_CString afile) ;

//! Sets  the location and  the name of  the file defining <br>
//!          the dictionary of materials. <br>
Standard_EXPORT static  void MaterialsFile(const Standard_CString afile) ;

//! Returns  the location and the   name of the dictionary <br>
//!          file of materials. <br>
Standard_EXPORT static  Standard_CString MaterialsFile() ;

//! Returns  the dictionary of materials.The dictionary is <br>
//!          created at  the first call to this  method, or  if the <br>
//!          dictionary is not up to date  with respect to the file <br>
//!          date. <br>
Standard_EXPORT static  Handle_Materials_MaterialsDictionary DictionaryOfMaterials() ;

//! True if the materialofname aName exists ... <br>
Standard_EXPORT static  Standard_Boolean ExistMaterial(const Standard_CString aName) ;

//! Retrieves from the dictionary the object material with <br>
//!          <amaterial> as name. <br>
Standard_EXPORT static  Handle_Materials_Material Material(const Standard_CString amaterial) ;

//! Returns  the number of  materials previously stored in <br>
//!          the dictionary. <br>
Standard_EXPORT static  Standard_Integer NumberOfMaterials() ;

//! This method used  with  the previous  one, allows  the <br>
//!          exploration of    all the  dictionary.  It   returns a <br>
//!          Material instance. <br>
Standard_EXPORT static  Handle_Materials_Material Material(const Standard_Integer anindex) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class Materials_Color;
friend class Materials_MaterialDefinition;
friend class Materials_MaterialsDictionary;
friend class Materials_FuzzyInstance;
friend class Materials_Material;
friend class Materials_MtsSequence;
friend class Materials_MaterialsSequence;
friend class Materials_SequenceNodeOfMtsSequence;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
