// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDF_ChildIDIterator_HeaderFile
#define _TDF_ChildIDIterator_HeaderFile

#ifndef _Standard_GUID_HeaderFile
#include <Standard_GUID.hxx>
#endif
#ifndef _TDF_ChildIterator_HeaderFile
#include <TDF_ChildIterator.hxx>
#endif
#ifndef _Handle_TDF_Attribute_HeaderFile
#include <Handle_TDF_Attribute.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TDF_Attribute;
class TDF_Label;
class Standard_GUID;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Iterates on the children of a label, to find <br>
//!          attributes having ID as Attribute ID. <br>
//! <br>
//!          Level option works as TDF_ChildIterator. <br>
class TDF_ChildIDIterator  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty iterator. <br>
Standard_EXPORT TDF_ChildIDIterator();

//! Iterates on the children of the given label. If <br>
//!          <allLevels> option is set to true, it explores not <br>
//!          only the first, but all the sub label levels. <br>
Standard_EXPORT TDF_ChildIDIterator(const TDF_Label& aLabel,const Standard_GUID& anID,const Standard_Boolean allLevels = Standard_False);

//! Initializes the iteration on the children of the <br>
//!          given label. If <allLevels> option is set to true, <br>
//!          it explores not only the first, but all the sub <br>
//!          label levels. <br>
Standard_EXPORT   void Initialize(const TDF_Label& aLabel,const Standard_GUID& anID,const Standard_Boolean allLevels = Standard_False) ;
//! Returns True if there is a current Item in the <br>
//!          iteration. <br>
//! <br>
  Standard_Boolean More() const;

//! Move to the next Item <br>
Standard_EXPORT   void Next() ;

//! Move to the next Brother. If there is none, go up <br>
//!          etc. This method is interesting only with <br>
//!          "allLevels" behavior, because it avoids to explore <br>
//!          the current label children. <br>
Standard_EXPORT   void NextBrother() ;
//! Returns the current item; a null handle if there is none. <br>
//! <br>
  Handle_TDF_Attribute Value() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_GUID myID;
TDF_ChildIterator myItr;
Handle_TDF_Attribute myAtt;


};


#include <TDF_ChildIDIterator.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
