// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDataStd_ExtStringArray_HeaderFile
#define _TDataStd_ExtStringArray_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TDataStd_ExtStringArray_HeaderFile
#include <Handle_TDataStd_ExtStringArray.hxx>
#endif

#ifndef _Handle_TColStd_HArray1OfExtendedString_HeaderFile
#include <Handle_TColStd_HArray1OfExtendedString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TDF_Attribute_HeaderFile
#include <TDF_Attribute.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TCollection_ExtendedString_HeaderFile
#include <TCollection_ExtendedString.hxx>
#endif
#ifndef _Handle_TDF_Attribute_HeaderFile
#include <Handle_TDF_Attribute.hxx>
#endif
#ifndef _Handle_TDF_RelocationTable_HeaderFile
#include <Handle_TDF_RelocationTable.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Handle_TDF_DeltaOnModification_HeaderFile
#include <Handle_TDF_DeltaOnModification.hxx>
#endif
class TColStd_HArray1OfExtendedString;
class TDataStd_DeltaOnModificationOfExtStringArray;
class Standard_GUID;
class TDF_Label;
class TCollection_ExtendedString;
class TDF_Attribute;
class TDF_RelocationTable;
class TDF_DeltaOnModification;


//! ExtStringArray Attribute. Handles an <br>
//! array of UNICODE strings (represented by the <br>
//! TCollection_ExtendedString class). <br>
class TDataStd_ExtStringArray : public TDF_Attribute {

public:
 // Methods PUBLIC
 // 

//! class methods <br>
//!          ============= <br>//! Returns the GUID for the attribute. <br>
Standard_EXPORT static const Standard_GUID& GetID() ;

//! Finds, or creates, an ExtStringArray attribute with <lower> <br>
//!          and <upper> bounds.  The ExtStringArray  attribute is returned. <br>
//!          If <isDelta> == False, DefaultDeltaOnModification is used. <br>
//! 	        If attribute is already set, all input parameters are refused <br>
//!          and the found attribute is returned. <br>
Standard_EXPORT static  Handle_TDataStd_ExtStringArray Set(const TDF_Label& label,const Standard_Integer lower,const Standard_Integer upper,const Standard_Boolean isDelta = Standard_False) ;

//! Initializes the inner array with bounds from <lower> to <upper> <br>
Standard_EXPORT   void Init(const Standard_Integer lower,const Standard_Integer upper) ;

//! Sets  the   <Index>th  element  of   the  array to <Value> <br>
Standard_EXPORT   void SetValue(const Standard_Integer Index,const TCollection_ExtendedString& Value) ;

//! Returns the value of  the  <Index>th element of the array <br>
Standard_EXPORT   TCollection_ExtendedString Value(const Standard_Integer Index) const;
  TCollection_ExtendedString operator ()(const Standard_Integer Index) const
{
  return Value(Index);
}


//!  Return the lower bound. <br>
Standard_EXPORT   Standard_Integer Lower() const;

//! Return the upper bound <br>
Standard_EXPORT   Standard_Integer Upper() const;

//! Return the number of elements of <me>. <br>
Standard_EXPORT   Standard_Integer Length() const;

//! Sets the inner array <myValue> of the ExtStringArray attribute to <newArray>. <br>
//! If value of <newArray> differs from <myValue>, Backup performed and myValue <br>
//! refers to new instance of HArray1OfExtendedString that holds <newArray> values <br>
//! If <isCheckItems> equal True each item of <newArray> will be checked with each <br>
//! item of <myValue> for coincidence (to avoid backup). <br>
Standard_EXPORT   void ChangeArray(const Handle(TColStd_HArray1OfExtendedString)& newArray,const Standard_Boolean isCheckItems = Standard_True) ;
//! Return the inner array of the ExtStringArray attribute <br>
 const Handle_TColStd_HArray1OfExtendedString Array() const;

  Standard_Boolean GetDelta() const;
//! for  internal  use  only! <br>
  void SetDelta(const Standard_Boolean isDelta) ;


Standard_EXPORT TDataStd_ExtStringArray();


Standard_EXPORT  const Standard_GUID& ID() const;


Standard_EXPORT   void Restore(const Handle(TDF_Attribute)& With) ;


Standard_EXPORT   Handle_TDF_Attribute NewEmpty() const;


Standard_EXPORT   void Paste(const Handle(TDF_Attribute)& Into,const Handle(TDF_RelocationTable)& RT) const;


Standard_EXPORT virtual  Standard_OStream& Dump(Standard_OStream& anOS) const;

//! Makes a DeltaOnModification between <me> and <br>
//!         <anOldAttribute>. <br>
Standard_EXPORT virtual  Handle_TDF_DeltaOnModification DeltaOnModification(const Handle(TDF_Attribute)& anOldAttribute) const;
//Standard_EXPORT ~TDataStd_ExtStringArray();


friend class TDataStd_DeltaOnModificationOfExtStringArray;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

  void RemoveArray() ;


 // Fields PRIVATE
 //
Handle_TColStd_HArray1OfExtendedString myValue;
Standard_Boolean myIsDelta;


};


#include <TDataStd_ExtStringArray.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
