// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopOpeBRepBuild_WireEdgeClassifier_HeaderFile
#define _TopOpeBRepBuild_WireEdgeClassifier_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _gp_Pnt2d_HeaderFile
#include <gp_Pnt2d.hxx>
#endif
#ifndef _BRepClass_Edge_HeaderFile
#include <BRepClass_Edge.hxx>
#endif
#ifndef _BRepClass_FacePassiveClassifier_HeaderFile
#include <BRepClass_FacePassiveClassifier.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _TopOpeBRepBuild_CompositeClassifier_HeaderFile
#include <TopOpeBRepBuild_CompositeClassifier.hxx>
#endif
#ifndef _TopAbs_State_HeaderFile
#include <TopAbs_State.hxx>
#endif
#ifndef _Handle_TopOpeBRepBuild_Loop_HeaderFile
#include <Handle_TopOpeBRepBuild_Loop.hxx>
#endif
class TopoDS_Shape;
class TopOpeBRepBuild_BlockBuilder;
class TopOpeBRepBuild_Loop;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! Classify edges and wires. <br>
//! shapes are Wires, Element are Edge. <br>
class TopOpeBRepBuild_WireEdgeClassifier  : public TopOpeBRepBuild_CompositeClassifier {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a classifier on edge <F>. <br>
//! Used to compare edges and wires on the edge <F>. <br>
Standard_EXPORT TopOpeBRepBuild_WireEdgeClassifier(const TopoDS_Shape& F,const TopOpeBRepBuild_BlockBuilder& BB);


Standard_EXPORT virtual  TopAbs_State Compare(const Handle(TopOpeBRepBuild_Loop)& L1,const Handle(TopOpeBRepBuild_Loop)& L2) ;


Standard_EXPORT   TopoDS_Shape LoopToShape(const Handle(TopOpeBRepBuild_Loop)& L) ;

//! classify wire <B1> with wire <B2> <br>
Standard_EXPORT   TopAbs_State CompareShapes(const TopoDS_Shape& B1,const TopoDS_Shape& B2) ;

//! classify edge <E> with wire <B> <br>
Standard_EXPORT   TopAbs_State CompareElementToShape(const TopoDS_Shape& E,const TopoDS_Shape& B) ;

//! prepare classification involving wire <B> <br>
//! calls ResetElement on first edge of <B> <br>
Standard_EXPORT   void ResetShape(const TopoDS_Shape& B) ;

//! prepare classification involving edge <E> <br>
//! define 2D point (later used in Compare()) on first vertex of edge <E>. <br>
Standard_EXPORT   void ResetElement(const TopoDS_Shape& E) ;

//! Add the edge <E> in the set of edges used in 2D point <br>
//! classification. <br>
Standard_EXPORT   void CompareElement(const TopoDS_Shape& E) ;

//! Returns state of classification of 2D point, defined by <br>
//! ResetElement, with the current set of edges, defined by Compare. <br>
Standard_EXPORT   TopAbs_State State() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myFirstCompare;
gp_Pnt2d myPoint2d;
BRepClass_Edge myBCEdge;
BRepClass_FacePassiveClassifier myFPC;
TopoDS_Shape myShape;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
