// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopOpeBRep_FFTransitionTool_HeaderFile
#define _TopOpeBRep_FFTransitionTool_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
class TopOpeBRepDS_Transition;
class TopOpeBRep_VPointInter;
class TopOpeBRep_LineInter;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class TopOpeBRep_FFTransitionTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT static  TopOpeBRepDS_Transition ProcessLineTransition(const TopOpeBRep_VPointInter& P,const Standard_Integer Index,const TopAbs_Orientation EdgeOrientation) ;


Standard_EXPORT static  TopOpeBRepDS_Transition ProcessLineTransition(const TopOpeBRep_VPointInter& P,const TopOpeBRep_LineInter& L) ;


Standard_EXPORT static  TopOpeBRepDS_Transition ProcessEdgeTransition(const TopOpeBRep_VPointInter& P,const Standard_Integer Index,const TopAbs_Orientation LineOrientation) ;


Standard_EXPORT static  TopOpeBRepDS_Transition ProcessFaceTransition(const TopOpeBRep_LineInter& L,const Standard_Integer Index,const TopAbs_Orientation FaceOrientation) ;

//! compute transition on "IntPatch_Restriction line" edge <R> <br>
//! when crossing edge <E> of face <F> at point <VP>. <br>
//! VP is given on edge <E> of face <F> of index <Index> (1 or 2). <br>
//! <VP> has been classified by FacesFiller as TopAbs_ON an edge <R> <br>
//! of the other face than <F> of current (face/face) intersection. <br>
//! Transition depends on the orientation of E in F. <br>
//! This method should be provided by IntPatch_Line (NYI) <br>
Standard_EXPORT static  TopOpeBRepDS_Transition ProcessEdgeONTransition(const TopOpeBRep_VPointInter& VP,const Standard_Integer Index,const TopoDS_Shape& R,const TopoDS_Shape& E,const TopoDS_Shape& F) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
