// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Transfer_TransferInput_HeaderFile
#define _Transfer_TransferInput_HeaderFile

#ifndef _Handle_Transfer_TransientProcess_HeaderFile
#include <Handle_Transfer_TransientProcess.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
#ifndef _Handle_Interface_Protocol_HeaderFile
#include <Handle_Interface_Protocol.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Transfer_FinderProcess_HeaderFile
#include <Handle_Transfer_FinderProcess.hxx>
#endif
class Transfer_TransferFailure;
class Interface_EntityIterator;
class Transfer_TransferIterator;
class Transfer_TransientProcess;
class Interface_InterfaceModel;
class Interface_Protocol;
class Transfer_FinderProcess;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A TransferInput is a Tool which fills an InterfaceModel with <br>
//!           the result of the Transfer of CasCade Objects, once determined <br>
//!           The Result comes from a TransferProcess, either from <br>
//!           Transient (the Complete Result is considered, it must contain <br>
//!           only Transient Objects) <br>
class Transfer_TransferInput  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a TransferInput ready to use <br>
Standard_EXPORT Transfer_TransferInput();

//! Takes the transient items stored in a TransferIterator <br>
Standard_EXPORT   Interface_EntityIterator Entities(Transfer_TransferIterator& list) const;

//! Fills an InterfaceModel with the Complete Result of a Transfer <br>
//!           stored in a TransientProcess (Starting Objects are Transient) <br>
//!           The complete result is exactly added to the model <br>
Standard_EXPORT   void FillModel(const Handle(Transfer_TransientProcess)& proc,const Handle(Interface_InterfaceModel)& amodel) const;

//! Fills an InterfaceModel with results of the Transfer recorded <br>
//!           in a TransientProcess (Starting Objects are Transient) : <br>
//!           Root Result if <roots> is True (Default), Complete Result else <br>
//!           The entities added to the model are determined from the result <br>
//!           by by adding the referenced entities <br>
Standard_EXPORT   void FillModel(const Handle(Transfer_TransientProcess)& proc,const Handle(Interface_InterfaceModel)& amodel,const Handle(Interface_Protocol)& proto,const Standard_Boolean roots = Standard_True) const;

//! Fills an InterfaceModel with the Complete Result of a Transfer <br>
//!           stored in a TransientProcess (Starting Objects are Transient) <br>
//!           The complete result is exactly added to the model <br>
Standard_EXPORT   void FillModel(const Handle(Transfer_FinderProcess)& proc,const Handle(Interface_InterfaceModel)& amodel) const;

//! Fills an InterfaceModel with results of the Transfer recorded <br>
//!           in a TransientProcess (Starting Objects are Transient) : <br>
//!           Root Result if <roots> is True (Default), Complete Result else <br>
//!           The entities added to the model are determined from the result <br>
//!           by by adding the referenced entities <br>
Standard_EXPORT   void FillModel(const Handle(Transfer_FinderProcess)& proc,const Handle(Interface_InterfaceModel)& amodel,const Handle(Interface_Protocol)& proto,const Standard_Boolean roots = Standard_True) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
