// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Units_Sentence_HeaderFile
#define _Units_Sentence_HeaderFile

#ifndef _Handle_Units_TokensSequence_HeaderFile
#include <Handle_Units_TokensSequence.hxx>
#endif
#ifndef _Handle_Units_Lexicon_HeaderFile
#include <Handle_Units_Lexicon.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_Units_Token_HeaderFile
#include <Handle_Units_Token.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Units_TokensSequence;
class Units_Lexicon;
class Units_Token;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class describes all the methods to create and <br>
//!          compute an expression contained in a string. <br>
class Units_Sentence  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates and  returns  a   Sentence, by  analyzing  the <br>
//!          string <astring> with the lexicon <alexicon>. <br>
Standard_EXPORT Units_Sentence(const Handle(Units_Lexicon)& alexicon,const Standard_CString astring);

//! For each constant encountered, sets the value. <br>
Standard_EXPORT   void SetConstants() ;
//! Returns <thesequenceoftokens>. <br>
  Handle_Units_TokensSequence Sequence() const;
//! Sets the field <thesequenceoftokens> to <asequenceoftokens>. <br>
  void Sequence(const Handle(Units_TokensSequence)& asequenceoftokens) ;

//! Computes and  returns in a   token the result  of  the <br>
//!          expression. <br>
Standard_EXPORT   Handle_Units_Token Evaluate() ;
//! Return True if number of created tokens > 0 <br>
//!          (i.e creation of sentence is succesfull) <br>
  Standard_Boolean IsDone() const;
//! Useful for debugging. <br>
  void Dump() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_Units_TokensSequence thesequenceoftokens;


};


#include <Units_Sentence.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
