/***************************************************************************
 *   Copyright (C) 2007 by Jean-Michel   *
 *   jm_petit@laposte.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "k9dialogs.h"
#include "k9process.h"
#include <QDebug>
#include <QString>
#include <KDialog>
#include <KLocale>
#include <KFileDialog>
#include <QProcess>
#include <QApplication>
#include "k9tools.h"
#include <KMessageBox>

bool useGtkFileDialogs;

QWidget * k9MainWidget;
void k9Dialogs::setMainWidget(QWidget *_widget) {
    k9MainWidget=_widget;
}

QWidget* k9Dialogs::getMainWidget() {
    return k9MainWidget;
}

void k9Dialogs::useGTK(bool _useIt) {
   useGtkFileDialogs=_useIt;
}

k9Dialogs::k9Dialogs(QObject *parent,k9Process *_process)
        : QObject(parent) {
    m_process=_process;
    connect(m_process, SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(receivedStdout(KProcess*, char*, int)));
    m_result="";
}


k9Dialogs::~k9Dialogs() {
}
void k9Dialogs::receivedStdout (KProcess *, char *buffer, int buflen) {
    
    QString res(QByteArray(buffer,buflen));
    if (res!="" && res !="\n")
        m_result=res.trimmed();

}

bool k9Dialogs::useGTK() {
    QStringList slEnv=QProcess::systemEnvironment();
    if (useGtkFileDialogs) 
	foreach (QString env,slEnv) {
		//qDebug() << env;
		if (env.startsWith("GNOME_DESKTOP_SESSION_ID="))
		if (k9Tools::checkProgram("zenity",false))
			return true;
	}
    return false;
}

QString k9Dialogs::getOpenFileName (const QString &_initialDir,const QString &_filter,QWidget *_parent,const QString &_title) {
    if ( useGTK()) {
        QWidget *activeWindow=QApplication::activeWindow();
        activeWindow->setDisabled(true);
        k9Process *process=new k9Process(0,0);
        k9Dialogs *dialog=new k9Dialogs(0,process);

        *process << "zenity" << "--file-selection" << "--title="+KDialog::makeStandardCaption(_title) <<"--filename=" +_initialDir +"/*";
        process->start();
        process->sync();
        QString res=dialog->result();
        delete dialog;
        delete process;
        activeWindow->setDisabled(false);
        return res.trimmed() ;
    } else
        return KFileDialog::getOpenFileName (_initialDir,_filter, _parent,_title);
}

QString k9Dialogs::getSaveFileName (const QString &_initialDir,const QString &_filter,QWidget *_parent,const QString &_title) {
    if ( useGTK()) {
        QWidget *activeWindow=QApplication::activeWindow();
        activeWindow->setDisabled(true);

        k9Process *process=new k9Process(0,0);
        k9Dialogs *dialog=new k9Dialogs(0,process);

        *process << "zenity" << "--file-selection" << "--title="+KDialog::makeStandardCaption(_title) <<"--filename=" +_initialDir+"/" << "--save";
        process->start();
        process->sync();
        QString res=dialog->result();
        delete dialog;
        delete process;
        activeWindow->setDisabled(false);

        return res.trimmed() ;
    } else
        return KFileDialog::getSaveFileName (_initialDir,_filter, _parent,_title);
}

QString k9Dialogs::getExistingDirectory (const QString &_initialDir) {
    if ( useGTK()) {
        QWidget *activeWindow=QApplication::activeWindow();
        activeWindow->setDisabled(true);

        k9Process *process=new k9Process(0,0);
        k9Dialogs *dialog=new k9Dialogs(0,process);

        *process << "zenity" << "--file-selection" << "--title="+KDialog::makeStandardCaption(i18n("select a directory")) <<"--filename=" +_initialDir+"/*" << "--directory";
        process->start();
        process->sync();
        QString res=dialog->result();
        delete dialog;
        delete process;
        activeWindow->setDisabled(false);

        return res.trimmed() ;
    } else
        return KFileDialog::getExistingDirectory (_initialDir);
}
QString k9Dialogs::result() const {
    return m_result;
}


void k9Dialogs::error(const QString &_message,const QString &_title,const QStringList &_detail) {
    QWidget *activeWindow=QApplication::activeWindow();
    if (activeWindow==0)
	activeWindow=k9MainWidget;
    KMessageBox::errorList(activeWindow,_message,_detail,_title);
}

void k9Dialogs::information(const QString &_message, const QString &_title) {
    QWidget *activeWindow=QApplication::activeWindow();
    if (activeWindow==0)
	activeWindow=k9MainWidget;
    KMessageBox::information(activeWindow,_message,_title);
}
int k9Dialogs::warningContinueCancel(const QString &  _message,const QString & _title,const QStringList &_detail) {
    QWidget *activeWindow=QApplication::activeWindow();
    if (activeWindow==0)
	activeWindow=k9MainWidget;
    return KMessageBox::warningContinueCancelList(activeWindow,_message,_detail,_title);
}
