//
// C++ Interface: k9menueditor
//
// Description: 
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef K9MENUEDITOR_H
#define K9MENUEDITOR_H

#include <q3canvas.h>

/**
	@author Jean-Michel PETIT <k9copy@free.fr>
*/

class k9MenuButton;
class k9MenuEdit;
class k9CanvasSelection;
class k9MenuEditor : public Q3CanvasView {
    Q_OBJECT

public:
    k9MenuEditor(Q3Canvas&, QWidget* parent=0);
    void clear();

    k9MenuButton* getSelected() ;
    void setMenu(k9MenuEdit *_menu) {
        m_menu=_menu;
    }

    Q3CanvasItem* getMoving() const;

    void setMoving(Q3CanvasItem* _value);
    QList< k9MenuButton *> *getSelection() ;
    void clearSelection();
    void hideSelection();
protected:
    void contentsMousePressEvent(QMouseEvent*);
    void contentsMouseMoveEvent(QMouseEvent*);
    void contentsMouseReleaseEvent(QMouseEvent* e);
    void updateCursor(QMouseEvent *e);
    virtual void resizeEvent ( QResizeEvent * e );
    void addSelection(Q3CanvasItem *_item);
    bool isSelected(Q3CanvasItem *_item);
    void drawSelection();
signals:
    void status(const QString&);
    void itemSelected();

private:
    Q3CanvasItem* moving;
    Q3CanvasRectangle *m_rect;
    QPoint moving_start;
    k9MenuEdit *m_menu;
    QList <k9MenuButton*> m_selection;
    k9CanvasSelection *m_canvasSelection;
};

#endif
