/// <reference types="react" />
export interface MenuItemActionProps extends React.HTMLProps<HTMLDivElement> {
    /** Additional classes added to the action button */
    className?: string;
    /** The action icon to use */
    icon?: 'favorites' | React.ReactNode;
    /** Callback on action click, can also specify onActionClick on the Menu instead */
    onClick?: (event?: any) => void;
    /** Accessibility label */
    'aria-label': string;
    /** Flag indicating if the item is favorited */
    isFavorited?: boolean;
    /** Disables action, can also be specified on the MenuItem instead */
    isDisabled?: boolean;
    /** Identifies the action item in the onActionClick on the Menu */
    actionId?: any;
    /** @hide Forwarded ref */
    innerRef?: React.Ref<any>;
}
export declare const MenuItemAction: import("react").ForwardRefExoticComponent<Omit<MenuItemActionProps, "ref"> & import("react").RefAttributes<HTMLButtonElement>>;
//# sourceMappingURL=MenuItemAction.d.ts.map