import { __rest } from "tslib";
import { jsx as _jsx } from "react/jsx-runtime";
import { forwardRef, useEffect, useRef } from 'react';
import styles from '@patternfly/react-styles/css/components/DualListSelector/dual-list-selector.mjs';
import { css } from '@patternfly/react-styles';
import { handleArrows } from '../../../helpers';
export const DualListSelectorControlsWrapperBase = (_a) => {
    var { innerRef, children = null, className, 'aria-label': ariaLabel = 'Controls for moving options between lists' } = _a, props = __rest(_a, ["innerRef", "children", "className", 'aria-label']);
    const ref = useRef(null);
    const wrapperRef = innerRef || ref;
    // Adds keyboard navigation to the dynamically built dual list selector controls. Works when controls are dynamically built
    // as well as when they are passed in via children.
    const handleKeys = (event) => {
        if (!wrapperRef.current ||
            (wrapperRef.current !== event.target.closest(`.${styles.dualListSelectorControls}`) &&
                !Array.from(wrapperRef.current.getElementsByClassName(styles.dualListSelectorControls)).includes(event.target.closest(`.${styles.dualListSelectorControls}`)))) {
            return;
        }
        event.stopImmediatePropagation();
        const controls = Array.from(wrapperRef.current.getElementsByTagName('BUTTON')).filter((el) => !el.classList.contains('pf-m-disabled'));
        const activeElement = document.activeElement;
        handleArrows(event, controls, (element) => activeElement.contains(element), (element) => element, undefined, undefined, true, false);
    };
    useEffect(() => {
        window.addEventListener('keydown', handleKeys);
        return () => {
            window.removeEventListener('keydown', handleKeys);
        };
    }, [wrapperRef.current]);
    return (_jsx("div", Object.assign({ className: css(styles.dualListSelectorControls, className), tabIndex: 0, ref: wrapperRef, "aria-label": ariaLabel }, props, { children: children })));
};
DualListSelectorControlsWrapperBase.displayName = 'DualListSelectorControlsWrapperBase';
export const DualListSelectorControlsWrapper = forwardRef((props, ref) => (_jsx(DualListSelectorControlsWrapperBase, Object.assign({ innerRef: ref, role: "group" }, props))));
DualListSelectorControlsWrapper.displayName = 'DualListSelectorControlsWrapper';
//# sourceMappingURL=DualListSelectorControlsWrapper.js.map