{-
    Kaya - My favourite toy language.
    Copyright (C) 2004-2006 Edwin Brady

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module Main where

import System
import System.Cmd
import Lib

-- Just invokes kayac with the -repl option added

main = do args <- getArgs
          banner
          if (execViaStart)
             then rawSystem "sh" (["/bin/start","kayac"]++args++["-repl"])
             else rawSystem "kayac" (args++["-repl"])

banner = putStrLn $
 " _                  \n" ++
 "| |____ _ _  _ __ _   Kaya top level, version " ++ version ++ "\n" ++
 "| / / _` | || / _` |  http://kayalang.org/\n" ++
 "|_\\_\\__,_|\\_, \\__,_|  Type :? for help\n" ++
 "          |__/      \n"
