/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef MAINWIDGET_H
#define MAINWIDGET_H

#include <QWidget>
#include "core/mpvtypes.h"

#define NormalMinSize   QSize(960, 540)
#define MiniModeSize    QSize(400, 225)

#define CenterLogoSize  QSize(500, 65)
#define MainButtonSize  QSize(118, 40)

#define MusicLogoSize   QSize(360, 120)

class QLabel;

class MpvCore;
class TopWindow;
class TitleMenu;
class ContralBar;
class AboutDialog;
class SetUpDialog;
class TitleWidget;
class PlayGLWidget;
class MiniModeShade;
class PlayListWidget;
class SystemTrayIcon;
class QDBusInterface;
class ShortCutSetting;
class KRightClickMenu;
class MediaInfoDialog;
class QPropertyAnimation;
class ContralShadeWidget;

namespace Ui {
class MainWidget;
}

class MainWidget : public QWidget
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.ukui.kylinvideo.play")

public:
    explicit MainWidget(QStringList list = QStringList(), QWidget *parent = nullptr);
    ~MainWidget();

    void ukuiMove();

public slots:
    void kylin_video_play_request(QStringList filelist);
    // s3 s4 处理
    void onPrepareForSleep(bool isSleep);
    void onPrepareForShutdown(bool Shutdown);
    void onScreenLock();
    void onScreenUnlock();

    // 耳机插拔
    void inputDeviceGet(QString _device);

private:
    void initMenu();
    void initCore();
    void initDBus();
    void initLayout();
    void initConnect();
    void initTrayIcon();
    void initGlobalSig();
//    void initContralBar();
//    void initTitleWidget();
    void initSetupDialog();
    void initAboutDialog();
//    void initPlayListWidget();
//    void initShowModeAnimation();

private slots:
    void slotToTop(bool is_top = true);
    void slotThemeChange(int theme);
    void slotPlayWidgetClicked();
    void slotOpenFile();
    void slotOpenDir();
    void slotPlayFile(QString file, int pos);
    void slotPlayStateChange(Mpv::PlayState state);
//    void slotHideAll(bool is_hide);

    void slotShowMin();
    void slotShowMax();
//    void slotShowNormalMode();
//    void slotShowMiniMode();

    void Single(QStringList filelist);

    void showText(QString text);
    void updateAspect();
    void appQuit();

    void onWiredControl(QString);

private:
    Ui::MainWidget *ui;
    QString m_currentFile;
    QDBusInterface *interface;
    QPropertyAnimation  *m_miniAnm,     // 切换 mini 模式动画
                        *m_normalAnm;   // 切换正常模式动画
    MiniModeShade *m_miniModeShade;     // mini 模式遮罩
    QSize m_normalSize;                 // 正常模式大小

    Mpv::VideoAspect m_vAspect;         // 视频比例
    bool m_needPlayWhenMin,             // 是否需要播放（最小化暂停）
         m_needPlayWhenS34,             // 是否需要播放（s3/s4）
         m_isMaxWindow,                 // 是否最大化窗口（全屏恢复使用）
         m_isScreenLocked,              // 是否锁屏了
         m_isMiniMode,                  // 是否 mini 模式
         m_canHideAll,                  // 是否能够隐藏标题栏和控制栏
         m_isActive,                    // 是否活动窗口
         m_moveFlag,                    // 窗口移动标志位
         m_exitFlag;                    // 退出应用标志位
    bool m_firstRemoveBar;              // wayland窗口第一次删除标题栏的时候会改变窗口的大小
    quint32 m_inhibitValue;             // 阻止锁屏cookie

    MpvCore *m_core;
    Mpv::PlayState m_playState;
    PlayGLWidget *m_playWidget;
    QWidget *m_centerLogo;
    QWidget *m_defaultFrame;            // 播放界面默认画面（灰色背景加logo）
    QWidget *m_musicLogo;
    QWidget *m_musicFrame;              // 音乐播放默认画面
    QTimer *m_osdShowTimer;
    QLabel *m_osdFrame;
    TopWindow *m_topWindow;

    TitleWidget *m_titleWidget;         // 标题栏
    TitleMenu   *m_titleMenu;           // 标题栏菜单
    ContralBar *m_contralBar;           // 控制栏
    KRightClickMenu *m_rightClickMenu;  // 右键菜单
//    MediaInfoDialog *m_mediaInfoDialog; // 媒体信息界面
    PlayListWidget *m_playListWidget;   // 播放列表界面
    SetUpDialog *m_setupDialog;         // 设置界面
    AboutDialog *m_aboutDialog;         // 关于界面
    SystemTrayIcon *m_trayIcon;         // 托盘图标

protected:
    void resizeEvent(QResizeEvent *event) override;
    bool event(QEvent *event) override;
    void mousePressEvent(QMouseEvent *event) override;
    void showEvent(QShowEvent *event) override;
    void closeEvent(QCloseEvent *event) override;
    void keyPressEvent(QKeyEvent *event) override;
    bool eventFilter(QObject *watched, QEvent *event) override;

    // 以下实现文件拖入播放
    void dragEnterEvent(QDragEnterEvent *event) override;
    void dropEvent(QDropEvent *event) override;
};

#endif // MAINWIDGET_H
