/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef TOPWINDOW_H
#define TOPWINDOW_H

#include <QDialog>
#include "core/mpvtypes.h"

#define NormalModeSize  QSize(960, 540)
#define MiniModeSize    QSize(400, 225)

class HomePage;
class TitleMenu;
class ContralBar;
class TitleWidget;
class SetUpDialog;
class AboutDialog;
class MiniModeShade;
class PlayListWidget;
class EventPassWidget;
class KRightClickMenu;

class QStackedWidget;

class TopWindow : public QDialog
{
    Q_OBJECT
public:
    TopWindow(QWidget *parent = nullptr);

public slots:
    void showMax();
    void showMin();
    void showTitleMenu();
    void showNormalMode();
    void showMiniMode();
    void slotShowFullScreen(bool full);
    void slotPlayStateChange(Mpv::PlayState state);
    void slotPlayWidgetClicked();
    void hideAll(bool hide);
    void setHide();
    void openHelpDoc();
    void resetLayout();

signals:
    void openFiles(QStringList files);
    void sigClose();
    void sigQuit();
    void sigMaxSize();
    void sigMinSize();

private:
    bool m_isMove,
         m_isMiniMode,
         m_isMaxWindow,
         m_isFullScreen,
         m_canHideAll;  // 能否隐藏，如果鼠标再标题上或者在控制栏上则不能隐藏.
    QRect m_normalRect;
    QPoint m_pressPos;
    QWidget *m_parentWidget;
    HomePage *m_homePage;
    QWidget *m_playPage;
    QStackedWidget *m_stackedWidget;

    TitleWidget *m_titleWidget;         // 标题栏
    TitleMenu   *m_titleMenu;           // 标题栏菜单
    ContralBar *m_contralBar;           // 控制栏
    KRightClickMenu *m_rightClickMenu;  // 右键菜单
    PlayListWidget *m_playListWidget;   // 播放列表界面
    SetUpDialog *m_setupDialog;         // 设置界面
    AboutDialog *m_aboutDialog;         // 关于界面

    MiniModeShade *m_miniModeShade;     // mini 模式遮罩
    EventPassWidget *m_eventPassWidget; // 播放鼠标事件穿透界面

private:
    void initGlobalSig();
    void initTitleWidget();
    void initContralBar();

    void initStackedWidget();
    void initMiniModeShade();
    void initPlayListWidget();

protected:
    void moveEvent(QMoveEvent *e) override;
    void mouseMoveEvent(QMouseEvent *e) override;
    void mousePressEvent(QMouseEvent *e) override;
    void mouseReleaseEvent(QMouseEvent *e) override;
    void resizeEvent(QResizeEvent *e) override;
    void showEvent(QShowEvent *event) override;
    void hideEvent(QHideEvent *event) override;
    void leaveEvent(QEvent *event) override;
    void enterEvent(QEvent *event) override;
    void keyPressEvent(QKeyEvent *event) override;
    // 以下实现文件拖入播放
    void dragEnterEvent(QDragEnterEvent *event) override;
    void dropEvent(QDropEvent *event) override;
};

#endif // TOPWINDOW_H
