program intrinsics_211
    use, intrinsic :: iso_fortran_env, only: dp => real64, sp => real32
    integer(4) :: n(32)
    real(dp) :: x(32)
    real(dp) :: expected(32)
    real(dp) :: expected_res(22)
    integer :: i

    real :: y(15)
    real :: expected_y(15)

    real(dp), parameter :: res(22) = bessel_yn( [0, 1, 2, 3, &
        4, 5, 6, 7, &
        8, 9, 10, 11, &
        12, 13, 14, 15, &
        16, 17, 18, 19, &
        20, 21], [9.98600559790084e307_dp, 9.98800479820072e307_dp, 9.9900039985006e307_dp, &
        9.99200319880048e307_dp, 1036.462826483388272_dp, 1.7197292882018389_dp, & 
        10.2368267382872828_dp, 0.17197292882018389_dp, 152.67283628_dp, &
        632.92729728_dp, 1.2728272919_dp, 1.265228272919_dp, &
        29.82407037185126_dp, 35.2459016393_dp, 46.2634946_dp, 24.7740903638_dp, &
        15.8978408636372_dp, 8.801468212714914_dp, 8.798080767692923_dp, 8.791287884846061575_dp, &
        9.98600559790084e307_dp, 9.98600559790084e307_dp])   

    expected_res = [7.9836428649154907E-155_dp, -3.6987410577069679E-155_dp, -4.4632457212022061E-155_dp, &
        7.9441122443324676E-155_dp, -2.1380390500553400E-002_dp, -19.681876164160990_dp, 0.26769853787891268_dp, &
        -6602481872.7862654_dp, 6.2260410422729083E-002_dp, 2.3302194134673972E-002_dp, -11087103.624584278_dp, &
        -185141909.80786872_dp, 9.9380926537565341E-003_dp, -9.5332917725880678E-002_dp, 5.6103040905370369E-002_dp, &
        -0.16533163717923532_dp, -0.31944510718813779_dp, -271.27888890185812_dp, -971.72716878320409_dp, &
        -3751.3930153366728_dp, 7.98364286491549068e-155_dp, 7.9836428649154907E-155_dp]

      do i = 1, size(res)
            print *, res(i)
            if (abs(res(i) - expected_res(i)) > 1e-5_dp) error stop
      end do

    n = [0, 1, 2, 3, &
        4, 5, 6, 7, &
        8, 9, 10, 11, &
        12, 17, 18, 19, &
        20, 21, 22, 23, &
        24, 25, 26, 27, &
        28, 29, 30, 31, &
        32, 37, 38, 39]

    x = [9.98600559790084e307_dp, 9.98800479820072e307_dp, 9.9900039985006e307_dp, 9.99200319880048e307_dp, &
        1036.462826483388272_dp, 1.7197292882018389_dp, 10.2368267382872828_dp, 0.17197292882018389_dp, &
        152.67283628_dp, 632.92729728_dp, 1.2728272919_dp, 1.265228272919_dp, &
        29.82407037185126_dp, 35.2459016393_dp, 46.2634946_dp, 24.7740903638_dp, &
        15.8978408636372_dp, 8.801468212714914_dp, 8.798080767692923_dp, 8.791287884846061575_dp, &
        0.6635324560331525_dp, 0.6633115808685429_dp, 0.6630906573122884_dp, 0.6628696853957159_dp, &
        0.5042349934053336_dp, 0.5041796815747646_dp, 0.5041242821300232_dp, 0.50401322049655_dp, &
        499.19032387045183_dp, 499.2802878848461_dp, 499.3702518992403_dp, 499.5501799280288_dp]

    expected = [7.9836428649154907E-155_dp, -3.6987410577069675E-155_dp, -4.4632457212022053E-155_dp, &
        7.9441122443324676E-155_dp, -2.1380390500553400E-002_dp, -19.681876164160990_dp, 0.26769853787891268_dp, &
        -6602481872.7862644_dp, 6.2260410422729083E-002_dp, 2.3302194134673972E-002_dp, -11087103.624584274_dp, &
        -185141909.80786863_dp, 9.9380926537565445E-003_dp, -8.4582551546166423E-002_dp, 0.11571053986948637_dp, &
        0.19158786386926477_dp, -1.6795286872077928_dp, -64130.286072844458_dp, -293361.46715134638_dp, &
        -1425639.5600599083_dp, -2.6148750349709140E+033_dp, -1.9070269429225925E+035_dp, -1.4497388677441211E+037_dp, &
        -1.1469745997353528E+039_dp, -1.9768410955067933E+044_dp, -2.2022757572664989E+046_dp, -2.5416271515658601E+048_dp, &
        -3.0455075866672117E+050_dp, 2.9475297628969036E-003_dp, 3.3552491139733728E-002_dp, 1.7701295549281584E-002_dp, &
        -2.5556786290672439E-002_dp]
    
    do i = 1, size(x)
        print *, bessel_yn(n(i), x(i)), "i = ", i
        if (abs((bessel_yn(n(i), x(i)) - expected(i))/expected(i)) > 1e-12_dp) error stop
    end do

    y = [1036.462826483388272_sp, 1.7197292882018389_sp, 10.2368267382872828_sp, 1036.462826483388272_sp, &
        152.67283628_sp, 632.92729728_sp, 1.2728272919_sp, 1.2828272919_sp, &
        29.82407037185126_sp, 35.2459016393_sp, 46.2634946_sp, 24.7740903638_sp, &
        15.8978408636372_sp, 8.801468212714914_sp, 036.462826483388272_sp]
    
    expected_y = [ -2.14771368E-02_sp, -0.272538334_sp, 5.23242168E-02_sp, 1.24606974E-02_sp, &
        5.87534383E-02_sp, 2.42299046E-02_sp, -623.942322_sp, -5497.98242_sp, &
        -0.143518567_sp, 6.74885958E-02_sp, -6.34354725E-02_sp, 3.99038307E-02_sp, &
        0.209239334_sp, -271.279022_sp, -8.33194777E-02_sp]

    do i = 1, size(y)
        print *, bessel_yn(n(i), y(i)), "i = ", i
        if (abs((bessel_yn(n(i), y(i)) - expected_y(i))/expected_y(i)) > 1e-5) error stop
    end do
end program
