// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _TopLoc_Location_HeaderFile
#define _TopLoc_Location_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TopLoc_SListOfItemLocation.hxx>
#include <Handle_TopLoc_Datum3D.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
#include <Standard_OStream.hxx>
class Standard_NoSuchObject;
class Standard_ConstructionError;
class gp_Trsf;
class TopLoc_Datum3D;


//! A Location is a composite transition. It comprises a
//! series of elementary reference coordinates, i.e.
//! objects of type TopLoc_Datum3D, and the powers to
//! which these objects are raised.
class TopLoc_Location 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Constructs an empty local coordinate system object.
  //! Note: A Location constructed from a default datum is said to be "empty".
  Standard_EXPORT TopLoc_Location();
  
  //! Constructs the local coordinate system object defined
  //! by the transformation T. T invokes in turn, a TopLoc_Datum3D object.
  Standard_EXPORT TopLoc_Location(const gp_Trsf& T);
  
  //! Constructs the local coordinate system object defined by the 3D datum D.
  //! Exceptions
  //! Standard_ConstructionError if the transformation
  //! T does not represent a 3D coordinate system.
  Standard_EXPORT TopLoc_Location(const Handle(TopLoc_Datum3D)& D);
  
  //! Returns true if this location is equal to the Identity transformation.
      Standard_Boolean IsIdentity()  const;
  
  //! Resets this location to the Identity transformation.
      void Identity() ;
  
  //! Returns    the  first   elementary  datum  of  the
  //! Location.  Use the NextLocation function recursively to access
  //! the other data comprising this location.
  //! Exceptions
  //! Standard_NoSuchObject if this location is empty.
     const  Handle(TopLoc_Datum3D)& FirstDatum()  const;
  
  //! Returns   the  power  elevation  of    the   first
  //! elementary datum.
  //! Exceptions
  //! Standard_NoSuchObject if this location is empty.
      Standard_Integer FirstPower()  const;
  
  //! Returns  a Location representing  <me> without the
  //! first datum. We have the relation :
  //!
  //! <me> = NextLocation() * FirstDatum() ^ FirstPower()
  //! Exceptions
  //! Standard_NoSuchObject if this location is empty.
     const  TopLoc_Location& NextLocation()  const;
  
  //! Returns  the transformation    associated  to  the
  //! coordinate system.
  Standard_EXPORT  const  gp_Trsf& Transformation()  const;
Standard_EXPORT operator gp_Trsf() const;
  
  //! Returns the inverse of <me>.
  //!
  //! <me> * Inverted() is an Identity.
  Standard_EXPORT   TopLoc_Location Inverted()  const;
  
  //! Returns <me> * <Other>, the  elementary datums are
  //! concatenated.
  Standard_EXPORT   TopLoc_Location Multiplied (const TopLoc_Location& Other)  const;
  TopLoc_Location operator* (const TopLoc_Location& Other)  const
{
  return Multiplied(Other);
}
  
  //! Returns  <me> / <Other>.
  Standard_EXPORT   TopLoc_Location Divided (const TopLoc_Location& Other)  const;
  TopLoc_Location operator/ (const TopLoc_Location& Other)  const
{
  return Divided(Other);
}
  
  //! Returns <Other>.Inverted() * <me>.
  Standard_EXPORT   TopLoc_Location Predivided (const TopLoc_Location& Other)  const;
  
  //! Returns me at the power <pwr>.   If <pwr>  is zero
  //! returns  Identity.  <pwr> can  be lower  than zero
  //! (usual meaning for powers).
  Standard_EXPORT   TopLoc_Location Powered (const Standard_Integer pwr)  const;
  
  //! Returns a hashed value for this local coordinate system.
  //! This value is used, with map tables, to store and
  //! retrieve the object easily, and is in the range [ 1..Upper ].
  Standard_EXPORT   Standard_Integer HashCode (const Standard_Integer Upper)  const;
  
  //! Returns true if this location and the location Other
  //! have the same elementary data, i.e. contain the same
  //! series of TopLoc_Datum3D and respective powers.
  //! This method is an alias for operator ==.
  Standard_EXPORT   Standard_Boolean IsEqual (const TopLoc_Location& Other)  const;
  Standard_Boolean operator == (const TopLoc_Location& Other)  const
{
  return IsEqual(Other);
}
  
  //! Returns true if this location and the location Other do
  //! not have the same elementary data, i.e. do not
  //! contain the same series of TopLoc_Datum3D and respective powers.
  //! This method is an alias for operator !=.
  Standard_EXPORT   Standard_Boolean IsDifferent (const TopLoc_Location& Other)  const;
  Standard_Boolean operator != (const TopLoc_Location& Other)  const
{
  return IsDifferent(Other);
}
  
  //! Prints the contents of <me> on the stream <s>.
  Standard_EXPORT   void ShallowDump (Standard_OStream& S)  const;




protected:





private:



  TopLoc_SListOfItemLocation myItems;


};


#include <TopLoc_Location.lxx>



inline Standard_Integer HashCode(const TopLoc_Location& me,const Standard_Integer Upper) {
 return me.HashCode(Upper);
}

inline void ShallowDump(const TopLoc_Location& me,Standard_OStream& S) {
 me.ShallowDump(S);
}



#endif // _TopLoc_Location_HeaderFile
