Interval, part of the collection of [Boost C++ Libraries](http://github.com/boostorg), is intended to help manipulating mathematical intervals.

### License

Distributed under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).

### Properties

* C++03
* Header-only

### Build Status

Branch          | GHA CI | Appveyor | Coverity Scan | codecov.io | Deps | Docs | Tests |
:-------------: | ------ | -------- | ------------- | ---------- | ---- | ---- | ----- |
[`master`](https://github.com/boostorg/interval/tree/master) | [![Build Status](https://github.com/boostorg/interval/actions/workflows/ci.yml/badge.svg?branch=master)](https://github.com/boostorg/interval/actions?query=branch:master) | [![Build status](https://ci.appveyor.com/api/projects/status/wx6gsonby36or5m2/branch/master?svg=true)](https://ci.appveyor.com/project/jeking3/interval-o0u28/branch/master) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/17151/badge.svg)](https://scan.coverity.com/projects/boostorg-interval) | [![codecov](https://codecov.io/gh/boostorg/interval/branch/master/graph/badge.svg)](https://codecov.io/gh/boostorg/interval/branch/master) | [![Deps](https://img.shields.io/badge/deps-master-brightgreen.svg)](https://pdimov.github.io/boostdep-report/master/interval.html) | [![Documentation](https://img.shields.io/badge/docs-master-brightgreen.svg)](https://www.boost.org/doc/libs/master/libs/numeric/interval/doc/interval.htm) | [![Enter the Matrix](https://img.shields.io/badge/matrix-master-brightgreen.svg)](http://www.boost.org/development/tests/master/developer/interval.html)
[`develop`](https://github.com/boostorg/interval/tree/develop) | [![Build Status](https://github.com/boostorg/interval/actions/workflows/ci.yml/badge.svg?branch=develop)](https://github.com/boostorg/interval/actions?query=branch:develop) | [![Build status](https://ci.appveyor.com/api/projects/status/wx6gsonby36or5m2/branch/develop?svg=true)](https://ci.appveyor.com/project/jeking3/interval-o0u28/branch/develop) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/17151/badge.svg)](https://scan.coverity.com/projects/boostorg-interval) | [![codecov](https://codecov.io/gh/boostorg/interval/branch/develop/graph/badge.svg)](https://codecov.io/gh/boostorg/interval/branch/develop) | [![Deps](https://img.shields.io/badge/deps-develop-brightgreen.svg)](https://pdimov.github.io/boostdep-report/develop/interval.html) | [![Documentation](https://img.shields.io/badge/docs-develop-brightgreen.svg)](https://www.boost.org/doc/libs/develop/libs/numeric/interval/doc/interval.htm) | [![Enter the Matrix](https://img.shields.io/badge/matrix-develop-brightgreen.svg)](http://www.boost.org/development/tests/develop/developer/interval.html)

### Directories

| Name        | Purpose                        |
| ----------- | ------------------------------ |
| `doc`       | documentation                  |
| `examples`  | use case examples              |
| `include`   | headers                        |
| `test`      | unit tests                     |

### More inintervalion

* [Ask questions](http://stackoverflow.com/questions/ask?tags=c%2B%2B,boost,boost-interval): Be sure to read the documentation first as Boost.Interval has specific requirements.
* [Report bugs](https://github.com/boostorg/interval/issues): Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* [Submit Pull Requests](https://github.com/boostorg/interval/pulls) against the **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).  Be sure to include tests proving your changes work properly.
* Discussions about the library are held on the [Boost developers mailing list](http://www.boost.org/community/groups.html#main). Be sure to read the [discussion policy](http://www.boost.org/community/policy.html) before posting and add the `[interval]` tag at the beginning of the subject line.

