// SPDX-License-Identifier: BSD-3-Clause
/* Copyright (C) 2022 Microchip Technology Inc. and its subsidiaries.
 * Microchip VCAP API
 */

/* This file is autogenerated by cml-utils 2022-10-13 10:04:41 +0200.
 * Commit ID: fd7cafd175899f0672c73afb3a30fc872500ae86
 */

#include <linux/types.h>
#include <linux/kernel.h>

#include "vcap_api.h"
#include "sparx5_vcap_ag_api.h"

/* keyfields */
static const struct vcap_field is2_mac_etype_keyfield[] = {
	[VCAP_KF_TYPE] = {
		.type = VCAP_FIELD_U32,
		.offset = 0,
		.width = 4,
	},
	[VCAP_KF_LOOKUP_FIRST_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 4,
		.width = 1,
	},
	[VCAP_KF_LOOKUP_PAG] = {
		.type = VCAP_FIELD_U32,
		.offset = 5,
		.width = 8,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_L3] = {
		.type = VCAP_FIELD_BIT,
		.offset = 13,
		.width = 1,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_RNG] = {
		.type = VCAP_FIELD_U32,
		.offset = 14,
		.width = 4,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_SEL] = {
		.type = VCAP_FIELD_U32,
		.offset = 18,
		.width = 2,
	},
	[VCAP_KF_IF_IGR_PORT_MASK] = {
		.type = VCAP_FIELD_U32,
		.offset = 20,
		.width = 32,
	},
	[VCAP_KF_L2_MC_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 52,
		.width = 1,
	},
	[VCAP_KF_L2_BC_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 53,
		.width = 1,
	},
	[VCAP_KF_8021Q_VLAN_TAGGED_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 54,
		.width = 1,
	},
	[VCAP_KF_ISDX_GT0_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 55,
		.width = 1,
	},
	[VCAP_KF_ISDX_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 56,
		.width = 12,
	},
	[VCAP_KF_8021Q_VID_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 68,
		.width = 13,
	},
	[VCAP_KF_8021Q_DEI_CLS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 81,
		.width = 1,
	},
	[VCAP_KF_8021Q_PCP_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 82,
		.width = 3,
	},
	[VCAP_KF_L2_FWD_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 85,
		.width = 1,
	},
	[VCAP_KF_L3_RT_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 88,
		.width = 1,
	},
	[VCAP_KF_L3_DST_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 89,
		.width = 1,
	},
	[VCAP_KF_L2_DMAC] = {
		.type = VCAP_FIELD_U48,
		.offset = 90,
		.width = 48,
	},
	[VCAP_KF_L2_SMAC] = {
		.type = VCAP_FIELD_U48,
		.offset = 138,
		.width = 48,
	},
	[VCAP_KF_ETYPE_LEN_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 186,
		.width = 1,
	},
	[VCAP_KF_ETYPE] = {
		.type = VCAP_FIELD_U32,
		.offset = 187,
		.width = 16,
	},
	[VCAP_KF_L2_PAYLOAD_ETYPE] = {
		.type = VCAP_FIELD_U64,
		.offset = 203,
		.width = 64,
	},
	[VCAP_KF_L4_RNG] = {
		.type = VCAP_FIELD_U32,
		.offset = 267,
		.width = 16,
	},
	[VCAP_KF_OAM_CCM_CNTS_EQ0] = {
		.type = VCAP_FIELD_BIT,
		.offset = 283,
		.width = 1,
	},
	[VCAP_KF_OAM_Y1731_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 284,
		.width = 1,
	},
};

static const struct vcap_field is2_arp_keyfield[] = {
	[VCAP_KF_TYPE] = {
		.type = VCAP_FIELD_U32,
		.offset = 0,
		.width = 4,
	},
	[VCAP_KF_LOOKUP_FIRST_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 4,
		.width = 1,
	},
	[VCAP_KF_LOOKUP_PAG] = {
		.type = VCAP_FIELD_U32,
		.offset = 5,
		.width = 8,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_L3] = {
		.type = VCAP_FIELD_BIT,
		.offset = 13,
		.width = 1,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_RNG] = {
		.type = VCAP_FIELD_U32,
		.offset = 14,
		.width = 4,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_SEL] = {
		.type = VCAP_FIELD_U32,
		.offset = 18,
		.width = 2,
	},
	[VCAP_KF_IF_IGR_PORT_MASK] = {
		.type = VCAP_FIELD_U32,
		.offset = 20,
		.width = 32,
	},
	[VCAP_KF_L2_MC_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 52,
		.width = 1,
	},
	[VCAP_KF_L2_BC_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 53,
		.width = 1,
	},
	[VCAP_KF_8021Q_VLAN_TAGGED_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 54,
		.width = 1,
	},
	[VCAP_KF_ISDX_GT0_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 55,
		.width = 1,
	},
	[VCAP_KF_ISDX_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 56,
		.width = 12,
	},
	[VCAP_KF_8021Q_VID_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 68,
		.width = 13,
	},
	[VCAP_KF_8021Q_DEI_CLS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 81,
		.width = 1,
	},
	[VCAP_KF_8021Q_PCP_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 82,
		.width = 3,
	},
	[VCAP_KF_L2_FWD_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 85,
		.width = 1,
	},
	[VCAP_KF_L2_SMAC] = {
		.type = VCAP_FIELD_U48,
		.offset = 86,
		.width = 48,
	},
	[VCAP_KF_ARP_ADDR_SPACE_OK_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 134,
		.width = 1,
	},
	[VCAP_KF_ARP_PROTO_SPACE_OK_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 135,
		.width = 1,
	},
	[VCAP_KF_ARP_LEN_OK_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 136,
		.width = 1,
	},
	[VCAP_KF_ARP_TGT_MATCH_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 137,
		.width = 1,
	},
	[VCAP_KF_ARP_SENDER_MATCH_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 138,
		.width = 1,
	},
	[VCAP_KF_ARP_OPCODE_UNKNOWN_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 139,
		.width = 1,
	},
	[VCAP_KF_ARP_OPCODE] = {
		.type = VCAP_FIELD_U32,
		.offset = 140,
		.width = 2,
	},
	[VCAP_KF_L3_IP4_DIP] = {
		.type = VCAP_FIELD_U32,
		.offset = 142,
		.width = 32,
	},
	[VCAP_KF_L3_IP4_SIP] = {
		.type = VCAP_FIELD_U32,
		.offset = 174,
		.width = 32,
	},
	[VCAP_KF_L3_DIP_EQ_SIP_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 206,
		.width = 1,
	},
	[VCAP_KF_L4_RNG] = {
		.type = VCAP_FIELD_U32,
		.offset = 207,
		.width = 16,
	},
};

static const struct vcap_field is2_ip4_tcp_udp_keyfield[] = {
	[VCAP_KF_TYPE] = {
		.type = VCAP_FIELD_U32,
		.offset = 0,
		.width = 4,
	},
	[VCAP_KF_LOOKUP_FIRST_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 4,
		.width = 1,
	},
	[VCAP_KF_LOOKUP_PAG] = {
		.type = VCAP_FIELD_U32,
		.offset = 5,
		.width = 8,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_L3] = {
		.type = VCAP_FIELD_BIT,
		.offset = 13,
		.width = 1,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_RNG] = {
		.type = VCAP_FIELD_U32,
		.offset = 14,
		.width = 4,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_SEL] = {
		.type = VCAP_FIELD_U32,
		.offset = 18,
		.width = 2,
	},
	[VCAP_KF_IF_IGR_PORT_MASK] = {
		.type = VCAP_FIELD_U32,
		.offset = 20,
		.width = 32,
	},
	[VCAP_KF_L2_MC_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 52,
		.width = 1,
	},
	[VCAP_KF_L2_BC_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 53,
		.width = 1,
	},
	[VCAP_KF_8021Q_VLAN_TAGGED_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 54,
		.width = 1,
	},
	[VCAP_KF_ISDX_GT0_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 55,
		.width = 1,
	},
	[VCAP_KF_ISDX_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 56,
		.width = 12,
	},
	[VCAP_KF_8021Q_VID_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 68,
		.width = 13,
	},
	[VCAP_KF_8021Q_DEI_CLS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 81,
		.width = 1,
	},
	[VCAP_KF_8021Q_PCP_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 82,
		.width = 3,
	},
	[VCAP_KF_L2_FWD_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 85,
		.width = 1,
	},
	[VCAP_KF_L3_RT_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 88,
		.width = 1,
	},
	[VCAP_KF_L3_DST_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 89,
		.width = 1,
	},
	[VCAP_KF_IP4_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 90,
		.width = 1,
	},
	[VCAP_KF_L3_FRAGMENT_TYPE] = {
		.type = VCAP_FIELD_U32,
		.offset = 91,
		.width = 2,
	},
	[VCAP_KF_L3_FRAG_INVLD_L4_LEN] = {
		.type = VCAP_FIELD_BIT,
		.offset = 93,
		.width = 1,
	},
	[VCAP_KF_L3_OPTIONS_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 94,
		.width = 1,
	},
	[VCAP_KF_L3_TTL_GT0] = {
		.type = VCAP_FIELD_BIT,
		.offset = 95,
		.width = 1,
	},
	[VCAP_KF_L3_TOS] = {
		.type = VCAP_FIELD_U32,
		.offset = 96,
		.width = 8,
	},
	[VCAP_KF_L3_IP4_DIP] = {
		.type = VCAP_FIELD_U32,
		.offset = 104,
		.width = 32,
	},
	[VCAP_KF_L3_IP4_SIP] = {
		.type = VCAP_FIELD_U32,
		.offset = 136,
		.width = 32,
	},
	[VCAP_KF_L3_DIP_EQ_SIP_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 168,
		.width = 1,
	},
	[VCAP_KF_TCP_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 169,
		.width = 1,
	},
	[VCAP_KF_L4_DPORT] = {
		.type = VCAP_FIELD_U32,
		.offset = 170,
		.width = 16,
	},
	[VCAP_KF_L4_SPORT] = {
		.type = VCAP_FIELD_U32,
		.offset = 186,
		.width = 16,
	},
	[VCAP_KF_L4_RNG] = {
		.type = VCAP_FIELD_U32,
		.offset = 202,
		.width = 16,
	},
	[VCAP_KF_L4_SPORT_EQ_DPORT_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 218,
		.width = 1,
	},
	[VCAP_KF_L4_SEQUENCE_EQ0_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 219,
		.width = 1,
	},
	[VCAP_KF_L4_FIN] = {
		.type = VCAP_FIELD_BIT,
		.offset = 220,
		.width = 1,
	},
	[VCAP_KF_L4_SYN] = {
		.type = VCAP_FIELD_BIT,
		.offset = 221,
		.width = 1,
	},
	[VCAP_KF_L4_RST] = {
		.type = VCAP_FIELD_BIT,
		.offset = 222,
		.width = 1,
	},
	[VCAP_KF_L4_PSH] = {
		.type = VCAP_FIELD_BIT,
		.offset = 223,
		.width = 1,
	},
	[VCAP_KF_L4_ACK] = {
		.type = VCAP_FIELD_BIT,
		.offset = 224,
		.width = 1,
	},
	[VCAP_KF_L4_URG] = {
		.type = VCAP_FIELD_BIT,
		.offset = 225,
		.width = 1,
	},
	[VCAP_KF_L4_PAYLOAD] = {
		.type = VCAP_FIELD_U64,
		.offset = 226,
		.width = 64,
	},
};

static const struct vcap_field is2_ip4_other_keyfield[] = {
	[VCAP_KF_TYPE] = {
		.type = VCAP_FIELD_U32,
		.offset = 0,
		.width = 4,
	},
	[VCAP_KF_LOOKUP_FIRST_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 4,
		.width = 1,
	},
	[VCAP_KF_LOOKUP_PAG] = {
		.type = VCAP_FIELD_U32,
		.offset = 5,
		.width = 8,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_L3] = {
		.type = VCAP_FIELD_BIT,
		.offset = 13,
		.width = 1,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_RNG] = {
		.type = VCAP_FIELD_U32,
		.offset = 14,
		.width = 4,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_SEL] = {
		.type = VCAP_FIELD_U32,
		.offset = 18,
		.width = 2,
	},
	[VCAP_KF_IF_IGR_PORT_MASK] = {
		.type = VCAP_FIELD_U32,
		.offset = 20,
		.width = 32,
	},
	[VCAP_KF_L2_MC_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 52,
		.width = 1,
	},
	[VCAP_KF_L2_BC_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 53,
		.width = 1,
	},
	[VCAP_KF_8021Q_VLAN_TAGGED_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 54,
		.width = 1,
	},
	[VCAP_KF_ISDX_GT0_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 55,
		.width = 1,
	},
	[VCAP_KF_ISDX_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 56,
		.width = 12,
	},
	[VCAP_KF_8021Q_VID_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 68,
		.width = 13,
	},
	[VCAP_KF_8021Q_DEI_CLS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 81,
		.width = 1,
	},
	[VCAP_KF_8021Q_PCP_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 82,
		.width = 3,
	},
	[VCAP_KF_L2_FWD_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 85,
		.width = 1,
	},
	[VCAP_KF_L3_RT_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 88,
		.width = 1,
	},
	[VCAP_KF_L3_DST_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 89,
		.width = 1,
	},
	[VCAP_KF_IP4_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 90,
		.width = 1,
	},
	[VCAP_KF_L3_FRAGMENT_TYPE] = {
		.type = VCAP_FIELD_U32,
		.offset = 91,
		.width = 2,
	},
	[VCAP_KF_L3_FRAG_INVLD_L4_LEN] = {
		.type = VCAP_FIELD_BIT,
		.offset = 93,
		.width = 1,
	},
	[VCAP_KF_L3_OPTIONS_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 94,
		.width = 1,
	},
	[VCAP_KF_L3_TTL_GT0] = {
		.type = VCAP_FIELD_BIT,
		.offset = 95,
		.width = 1,
	},
	[VCAP_KF_L3_TOS] = {
		.type = VCAP_FIELD_U32,
		.offset = 96,
		.width = 8,
	},
	[VCAP_KF_L3_IP4_DIP] = {
		.type = VCAP_FIELD_U32,
		.offset = 104,
		.width = 32,
	},
	[VCAP_KF_L3_IP4_SIP] = {
		.type = VCAP_FIELD_U32,
		.offset = 136,
		.width = 32,
	},
	[VCAP_KF_L3_DIP_EQ_SIP_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 168,
		.width = 1,
	},
	[VCAP_KF_L3_IP_PROTO] = {
		.type = VCAP_FIELD_U32,
		.offset = 169,
		.width = 8,
	},
	[VCAP_KF_L4_RNG] = {
		.type = VCAP_FIELD_U32,
		.offset = 177,
		.width = 16,
	},
	[VCAP_KF_L3_PAYLOAD] = {
		.type = VCAP_FIELD_U112,
		.offset = 193,
		.width = 96,
	},
};

static const struct vcap_field is2_ip6_std_keyfield[] = {
	[VCAP_KF_TYPE] = {
		.type = VCAP_FIELD_U32,
		.offset = 0,
		.width = 4,
	},
	[VCAP_KF_LOOKUP_FIRST_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 4,
		.width = 1,
	},
	[VCAP_KF_LOOKUP_PAG] = {
		.type = VCAP_FIELD_U32,
		.offset = 5,
		.width = 8,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_L3] = {
		.type = VCAP_FIELD_BIT,
		.offset = 13,
		.width = 1,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_RNG] = {
		.type = VCAP_FIELD_U32,
		.offset = 14,
		.width = 4,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_SEL] = {
		.type = VCAP_FIELD_U32,
		.offset = 18,
		.width = 2,
	},
	[VCAP_KF_IF_IGR_PORT_MASK] = {
		.type = VCAP_FIELD_U32,
		.offset = 20,
		.width = 32,
	},
	[VCAP_KF_L2_MC_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 52,
		.width = 1,
	},
	[VCAP_KF_L2_BC_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 53,
		.width = 1,
	},
	[VCAP_KF_8021Q_VLAN_TAGGED_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 54,
		.width = 1,
	},
	[VCAP_KF_ISDX_GT0_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 55,
		.width = 1,
	},
	[VCAP_KF_ISDX_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 56,
		.width = 12,
	},
	[VCAP_KF_8021Q_VID_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 68,
		.width = 13,
	},
	[VCAP_KF_8021Q_DEI_CLS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 81,
		.width = 1,
	},
	[VCAP_KF_8021Q_PCP_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 82,
		.width = 3,
	},
	[VCAP_KF_L2_FWD_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 85,
		.width = 1,
	},
	[VCAP_KF_L3_RT_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 88,
		.width = 1,
	},
	[VCAP_KF_L3_TTL_GT0] = {
		.type = VCAP_FIELD_BIT,
		.offset = 90,
		.width = 1,
	},
	[VCAP_KF_L3_IP6_SIP] = {
		.type = VCAP_FIELD_U128,
		.offset = 91,
		.width = 128,
	},
	[VCAP_KF_L3_DIP_EQ_SIP_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 219,
		.width = 1,
	},
	[VCAP_KF_L3_IP_PROTO] = {
		.type = VCAP_FIELD_U32,
		.offset = 220,
		.width = 8,
	},
	[VCAP_KF_L4_RNG] = {
		.type = VCAP_FIELD_U32,
		.offset = 228,
		.width = 16,
	},
	[VCAP_KF_L3_PAYLOAD] = {
		.type = VCAP_FIELD_U48,
		.offset = 244,
		.width = 40,
	},
};

static const struct vcap_field is2_ip_7tuple_keyfield[] = {
	[VCAP_KF_TYPE] = {
		.type = VCAP_FIELD_U32,
		.offset = 0,
		.width = 2,
	},
	[VCAP_KF_LOOKUP_FIRST_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 2,
		.width = 1,
	},
	[VCAP_KF_LOOKUP_PAG] = {
		.type = VCAP_FIELD_U32,
		.offset = 3,
		.width = 8,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_L3] = {
		.type = VCAP_FIELD_BIT,
		.offset = 11,
		.width = 1,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_RNG] = {
		.type = VCAP_FIELD_U32,
		.offset = 12,
		.width = 4,
	},
	[VCAP_KF_IF_IGR_PORT_MASK_SEL] = {
		.type = VCAP_FIELD_U32,
		.offset = 16,
		.width = 2,
	},
	[VCAP_KF_IF_IGR_PORT_MASK] = {
		.type = VCAP_FIELD_U72,
		.offset = 18,
		.width = 65,
	},
	[VCAP_KF_L2_MC_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 83,
		.width = 1,
	},
	[VCAP_KF_L2_BC_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 84,
		.width = 1,
	},
	[VCAP_KF_8021Q_VLAN_TAGGED_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 85,
		.width = 1,
	},
	[VCAP_KF_ISDX_GT0_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 86,
		.width = 1,
	},
	[VCAP_KF_ISDX_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 87,
		.width = 12,
	},
	[VCAP_KF_8021Q_VID_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 99,
		.width = 13,
	},
	[VCAP_KF_8021Q_DEI_CLS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 112,
		.width = 1,
	},
	[VCAP_KF_8021Q_PCP_CLS] = {
		.type = VCAP_FIELD_U32,
		.offset = 113,
		.width = 3,
	},
	[VCAP_KF_L2_FWD_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 116,
		.width = 1,
	},
	[VCAP_KF_L3_RT_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 119,
		.width = 1,
	},
	[VCAP_KF_L3_DST_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 120,
		.width = 1,
	},
	[VCAP_KF_L2_DMAC] = {
		.type = VCAP_FIELD_U48,
		.offset = 121,
		.width = 48,
	},
	[VCAP_KF_L2_SMAC] = {
		.type = VCAP_FIELD_U48,
		.offset = 169,
		.width = 48,
	},
	[VCAP_KF_IP4_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 217,
		.width = 1,
	},
	[VCAP_KF_L3_TTL_GT0] = {
		.type = VCAP_FIELD_BIT,
		.offset = 218,
		.width = 1,
	},
	[VCAP_KF_L3_TOS] = {
		.type = VCAP_FIELD_U32,
		.offset = 219,
		.width = 8,
	},
	[VCAP_KF_L3_IP6_DIP] = {
		.type = VCAP_FIELD_U128,
		.offset = 227,
		.width = 128,
	},
	[VCAP_KF_L3_IP6_SIP] = {
		.type = VCAP_FIELD_U128,
		.offset = 355,
		.width = 128,
	},
	[VCAP_KF_L3_DIP_EQ_SIP_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 483,
		.width = 1,
	},
	[VCAP_KF_TCP_UDP_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 484,
		.width = 1,
	},
	[VCAP_KF_TCP_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 485,
		.width = 1,
	},
	[VCAP_KF_L4_DPORT] = {
		.type = VCAP_FIELD_U32,
		.offset = 486,
		.width = 16,
	},
	[VCAP_KF_L4_SPORT] = {
		.type = VCAP_FIELD_U32,
		.offset = 502,
		.width = 16,
	},
	[VCAP_KF_L4_RNG] = {
		.type = VCAP_FIELD_U32,
		.offset = 518,
		.width = 16,
	},
	[VCAP_KF_L4_SPORT_EQ_DPORT_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 534,
		.width = 1,
	},
	[VCAP_KF_L4_SEQUENCE_EQ0_IS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 535,
		.width = 1,
	},
	[VCAP_KF_L4_FIN] = {
		.type = VCAP_FIELD_BIT,
		.offset = 536,
		.width = 1,
	},
	[VCAP_KF_L4_SYN] = {
		.type = VCAP_FIELD_BIT,
		.offset = 537,
		.width = 1,
	},
	[VCAP_KF_L4_RST] = {
		.type = VCAP_FIELD_BIT,
		.offset = 538,
		.width = 1,
	},
	[VCAP_KF_L4_PSH] = {
		.type = VCAP_FIELD_BIT,
		.offset = 539,
		.width = 1,
	},
	[VCAP_KF_L4_ACK] = {
		.type = VCAP_FIELD_BIT,
		.offset = 540,
		.width = 1,
	},
	[VCAP_KF_L4_URG] = {
		.type = VCAP_FIELD_BIT,
		.offset = 541,
		.width = 1,
	},
	[VCAP_KF_L4_PAYLOAD] = {
		.type = VCAP_FIELD_U64,
		.offset = 542,
		.width = 64,
	},
};

/* keyfield_set */
static const struct vcap_set is2_keyfield_set[] = {
	[VCAP_KFS_MAC_ETYPE] = {
		.type_id = 0,
		.sw_per_item = 6,
		.sw_cnt = 2,
	},
	[VCAP_KFS_ARP] = {
		.type_id = 3,
		.sw_per_item = 6,
		.sw_cnt = 2,
	},
	[VCAP_KFS_IP4_TCP_UDP] = {
		.type_id = 4,
		.sw_per_item = 6,
		.sw_cnt = 2,
	},
	[VCAP_KFS_IP4_OTHER] = {
		.type_id = 5,
		.sw_per_item = 6,
		.sw_cnt = 2,
	},
	[VCAP_KFS_IP6_STD] = {
		.type_id = 6,
		.sw_per_item = 6,
		.sw_cnt = 2,
	},
	[VCAP_KFS_IP_7TUPLE] = {
		.type_id = 1,
		.sw_per_item = 12,
		.sw_cnt = 1,
	},
};

/* keyfield_set map */
static const struct vcap_field *is2_keyfield_set_map[] = {
	[VCAP_KFS_MAC_ETYPE] = is2_mac_etype_keyfield,
	[VCAP_KFS_ARP] = is2_arp_keyfield,
	[VCAP_KFS_IP4_TCP_UDP] = is2_ip4_tcp_udp_keyfield,
	[VCAP_KFS_IP4_OTHER] = is2_ip4_other_keyfield,
	[VCAP_KFS_IP6_STD] = is2_ip6_std_keyfield,
	[VCAP_KFS_IP_7TUPLE] = is2_ip_7tuple_keyfield,
};

/* keyfield_set map sizes */
static int is2_keyfield_set_map_size[] = {
	[VCAP_KFS_MAC_ETYPE] = ARRAY_SIZE(is2_mac_etype_keyfield),
	[VCAP_KFS_ARP] = ARRAY_SIZE(is2_arp_keyfield),
	[VCAP_KFS_IP4_TCP_UDP] = ARRAY_SIZE(is2_ip4_tcp_udp_keyfield),
	[VCAP_KFS_IP4_OTHER] = ARRAY_SIZE(is2_ip4_other_keyfield),
	[VCAP_KFS_IP6_STD] = ARRAY_SIZE(is2_ip6_std_keyfield),
	[VCAP_KFS_IP_7TUPLE] = ARRAY_SIZE(is2_ip_7tuple_keyfield),
};

/* actionfields */
static const struct vcap_field is2_base_type_actionfield[] = {
	[VCAP_AF_PIPELINE_FORCE_ENA] = {
		.type = VCAP_FIELD_BIT,
		.offset = 1,
		.width = 1,
	},
	[VCAP_AF_PIPELINE_PT] = {
		.type = VCAP_FIELD_U32,
		.offset = 2,
		.width = 5,
	},
	[VCAP_AF_HIT_ME_ONCE] = {
		.type = VCAP_FIELD_BIT,
		.offset = 7,
		.width = 1,
	},
	[VCAP_AF_INTR_ENA] = {
		.type = VCAP_FIELD_BIT,
		.offset = 8,
		.width = 1,
	},
	[VCAP_AF_CPU_COPY_ENA] = {
		.type = VCAP_FIELD_BIT,
		.offset = 9,
		.width = 1,
	},
	[VCAP_AF_CPU_QUEUE_NUM] = {
		.type = VCAP_FIELD_U32,
		.offset = 10,
		.width = 3,
	},
	[VCAP_AF_LRN_DIS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 14,
		.width = 1,
	},
	[VCAP_AF_RT_DIS] = {
		.type = VCAP_FIELD_BIT,
		.offset = 15,
		.width = 1,
	},
	[VCAP_AF_POLICE_ENA] = {
		.type = VCAP_FIELD_BIT,
		.offset = 16,
		.width = 1,
	},
	[VCAP_AF_POLICE_IDX] = {
		.type = VCAP_FIELD_U32,
		.offset = 17,
		.width = 6,
	},
	[VCAP_AF_IGNORE_PIPELINE_CTRL] = {
		.type = VCAP_FIELD_BIT,
		.offset = 23,
		.width = 1,
	},
	[VCAP_AF_MASK_MODE] = {
		.type = VCAP_FIELD_U32,
		.offset = 27,
		.width = 3,
	},
	[VCAP_AF_PORT_MASK] = {
		.type = VCAP_FIELD_U72,
		.offset = 30,
		.width = 68,
	},
	[VCAP_AF_MIRROR_PROBE] = {
		.type = VCAP_FIELD_U32,
		.offset = 111,
		.width = 2,
	},
	[VCAP_AF_MATCH_ID] = {
		.type = VCAP_FIELD_U32,
		.offset = 159,
		.width = 16,
	},
	[VCAP_AF_MATCH_ID_MASK] = {
		.type = VCAP_FIELD_U32,
		.offset = 175,
		.width = 16,
	},
	[VCAP_AF_CNT_ID] = {
		.type = VCAP_FIELD_U32,
		.offset = 191,
		.width = 12,
	},
};

/* actionfield_set */
static const struct vcap_set is2_actionfield_set[] = {
	[VCAP_AFS_BASE_TYPE] = {
		.type_id = -1,
		.sw_per_item = 3,
		.sw_cnt = 4,
	},
};

/* actionfield_set map */
static const struct vcap_field *is2_actionfield_set_map[] = {
	[VCAP_AFS_BASE_TYPE] = is2_base_type_actionfield,
};

/* actionfield_set map size */
static int is2_actionfield_set_map_size[] = {
	[VCAP_AFS_BASE_TYPE] = ARRAY_SIZE(is2_base_type_actionfield),
};

/* Type Groups */
static const struct vcap_typegroup is2_x12_keyfield_set_typegroups[] = {
	{
		.offset = 0,
		.width = 3,
		.value = 4,
	},
	{
		.offset = 156,
		.width = 1,
		.value = 0,
	},
	{
		.offset = 312,
		.width = 2,
		.value = 0,
	},
	{
		.offset = 468,
		.width = 1,
		.value = 0,
	},
	{}
};

static const struct vcap_typegroup is2_x6_keyfield_set_typegroups[] = {
	{
		.offset = 0,
		.width = 2,
		.value = 2,
	},
	{
		.offset = 156,
		.width = 1,
		.value = 0,
	},
	{}
};

static const struct vcap_typegroup is2_x3_keyfield_set_typegroups[] = {
	{}
};

static const struct vcap_typegroup is2_x1_keyfield_set_typegroups[] = {
	{}
};

static const struct vcap_typegroup *is2_keyfield_set_typegroups[] = {
	[12] = is2_x12_keyfield_set_typegroups,
	[6] = is2_x6_keyfield_set_typegroups,
	[3] = is2_x3_keyfield_set_typegroups,
	[1] = is2_x1_keyfield_set_typegroups,
	[13] = NULL,
};

static const struct vcap_typegroup is2_x3_actionfield_set_typegroups[] = {
	{
		.offset = 0,
		.width = 2,
		.value = 2,
	},
	{
		.offset = 110,
		.width = 1,
		.value = 0,
	},
	{
		.offset = 220,
		.width = 1,
		.value = 0,
	},
	{}
};

static const struct vcap_typegroup is2_x1_actionfield_set_typegroups[] = {
	{}
};

static const struct vcap_typegroup *is2_actionfield_set_typegroups[] = {
	[3] = is2_x3_actionfield_set_typegroups,
	[1] = is2_x1_actionfield_set_typegroups,
	[13] = NULL,
};

/* Keyfieldset names */
static const char * const vcap_keyfield_set_names[] = {
	[VCAP_KFS_NO_VALUE]                      =  "(None)",
	[VCAP_KFS_ARP]                           =  "VCAP_KFS_ARP",
	[VCAP_KFS_IP4_OTHER]                     =  "VCAP_KFS_IP4_OTHER",
	[VCAP_KFS_IP4_TCP_UDP]                   =  "VCAP_KFS_IP4_TCP_UDP",
	[VCAP_KFS_IP6_STD]                       =  "VCAP_KFS_IP6_STD",
	[VCAP_KFS_IP_7TUPLE]                     =  "VCAP_KFS_IP_7TUPLE",
	[VCAP_KFS_MAC_ETYPE]                     =  "VCAP_KFS_MAC_ETYPE",
};

/* Actionfieldset names */
static const char * const vcap_actionfield_set_names[] = {
	[VCAP_AFS_NO_VALUE]                      =  "(None)",
	[VCAP_AFS_BASE_TYPE]                     =  "VCAP_AFS_BASE_TYPE",
};

/* Keyfield names */
static const char * const vcap_keyfield_names[] = {
	[VCAP_KF_NO_VALUE]                       =  "(None)",
	[VCAP_KF_8021Q_DEI_CLS]                  =  "8021Q_DEI_CLS",
	[VCAP_KF_8021Q_PCP_CLS]                  =  "8021Q_PCP_CLS",
	[VCAP_KF_8021Q_VID_CLS]                  =  "8021Q_VID_CLS",
	[VCAP_KF_8021Q_VLAN_TAGGED_IS]           =  "8021Q_VLAN_TAGGED_IS",
	[VCAP_KF_ARP_ADDR_SPACE_OK_IS]           =  "ARP_ADDR_SPACE_OK_IS",
	[VCAP_KF_ARP_LEN_OK_IS]                  =  "ARP_LEN_OK_IS",
	[VCAP_KF_ARP_OPCODE]                     =  "ARP_OPCODE",
	[VCAP_KF_ARP_OPCODE_UNKNOWN_IS]          =  "ARP_OPCODE_UNKNOWN_IS",
	[VCAP_KF_ARP_PROTO_SPACE_OK_IS]          =  "ARP_PROTO_SPACE_OK_IS",
	[VCAP_KF_ARP_SENDER_MATCH_IS]            =  "ARP_SENDER_MATCH_IS",
	[VCAP_KF_ARP_TGT_MATCH_IS]               =  "ARP_TGT_MATCH_IS",
	[VCAP_KF_ETYPE]                          =  "ETYPE",
	[VCAP_KF_ETYPE_LEN_IS]                   =  "ETYPE_LEN_IS",
	[VCAP_KF_IF_IGR_PORT_MASK]               =  "IF_IGR_PORT_MASK",
	[VCAP_KF_IF_IGR_PORT_MASK_L3]            =  "IF_IGR_PORT_MASK_L3",
	[VCAP_KF_IF_IGR_PORT_MASK_RNG]           =  "IF_IGR_PORT_MASK_RNG",
	[VCAP_KF_IF_IGR_PORT_MASK_SEL]           =  "IF_IGR_PORT_MASK_SEL",
	[VCAP_KF_IP4_IS]                         =  "IP4_IS",
	[VCAP_KF_ISDX_CLS]                       =  "ISDX_CLS",
	[VCAP_KF_ISDX_GT0_IS]                    =  "ISDX_GT0_IS",
	[VCAP_KF_L2_BC_IS]                       =  "L2_BC_IS",
	[VCAP_KF_L2_DMAC]                        =  "L2_DMAC",
	[VCAP_KF_L2_FWD_IS]                      =  "L2_FWD_IS",
	[VCAP_KF_L2_MC_IS]                       =  "L2_MC_IS",
	[VCAP_KF_L2_PAYLOAD_ETYPE]               =  "L2_PAYLOAD_ETYPE",
	[VCAP_KF_L2_SMAC]                        =  "L2_SMAC",
	[VCAP_KF_L3_DIP_EQ_SIP_IS]               =  "L3_DIP_EQ_SIP_IS",
	[VCAP_KF_L3_DST_IS]                      =  "L3_DST_IS",
	[VCAP_KF_L3_FRAGMENT_TYPE]               =  "L3_FRAGMENT_TYPE",
	[VCAP_KF_L3_FRAG_INVLD_L4_LEN]           =  "L3_FRAG_INVLD_L4_LEN",
	[VCAP_KF_L3_IP4_DIP]                     =  "L3_IP4_DIP",
	[VCAP_KF_L3_IP4_SIP]                     =  "L3_IP4_SIP",
	[VCAP_KF_L3_IP6_DIP]                     =  "L3_IP6_DIP",
	[VCAP_KF_L3_IP6_SIP]                     =  "L3_IP6_SIP",
	[VCAP_KF_L3_IP_PROTO]                    =  "L3_IP_PROTO",
	[VCAP_KF_L3_OPTIONS_IS]                  =  "L3_OPTIONS_IS",
	[VCAP_KF_L3_PAYLOAD]                     =  "L3_PAYLOAD",
	[VCAP_KF_L3_RT_IS]                       =  "L3_RT_IS",
	[VCAP_KF_L3_TOS]                         =  "L3_TOS",
	[VCAP_KF_L3_TTL_GT0]                     =  "L3_TTL_GT0",
	[VCAP_KF_L4_ACK]                         =  "L4_ACK",
	[VCAP_KF_L4_DPORT]                       =  "L4_DPORT",
	[VCAP_KF_L4_FIN]                         =  "L4_FIN",
	[VCAP_KF_L4_PAYLOAD]                     =  "L4_PAYLOAD",
	[VCAP_KF_L4_PSH]                         =  "L4_PSH",
	[VCAP_KF_L4_RNG]                         =  "L4_RNG",
	[VCAP_KF_L4_RST]                         =  "L4_RST",
	[VCAP_KF_L4_SEQUENCE_EQ0_IS]             =  "L4_SEQUENCE_EQ0_IS",
	[VCAP_KF_L4_SPORT]                       =  "L4_SPORT",
	[VCAP_KF_L4_SPORT_EQ_DPORT_IS]           =  "L4_SPORT_EQ_DPORT_IS",
	[VCAP_KF_L4_SYN]                         =  "L4_SYN",
	[VCAP_KF_L4_URG]                         =  "L4_URG",
	[VCAP_KF_LOOKUP_FIRST_IS]                =  "LOOKUP_FIRST_IS",
	[VCAP_KF_LOOKUP_PAG]                     =  "LOOKUP_PAG",
	[VCAP_KF_OAM_CCM_CNTS_EQ0]               =  "OAM_CCM_CNTS_EQ0",
	[VCAP_KF_OAM_Y1731_IS]                   =  "OAM_Y1731_IS",
	[VCAP_KF_TCP_IS]                         =  "TCP_IS",
	[VCAP_KF_TCP_UDP_IS]                     =  "TCP_UDP_IS",
	[VCAP_KF_TYPE]                           =  "TYPE",
};

/* Actionfield names */
static const char * const vcap_actionfield_names[] = {
	[VCAP_AF_NO_VALUE]                       =  "(None)",
	[VCAP_AF_CNT_ID]                         =  "CNT_ID",
	[VCAP_AF_CPU_COPY_ENA]                   =  "CPU_COPY_ENA",
	[VCAP_AF_CPU_QUEUE_NUM]                  =  "CPU_QUEUE_NUM",
	[VCAP_AF_HIT_ME_ONCE]                    =  "HIT_ME_ONCE",
	[VCAP_AF_IGNORE_PIPELINE_CTRL]           =  "IGNORE_PIPELINE_CTRL",
	[VCAP_AF_INTR_ENA]                       =  "INTR_ENA",
	[VCAP_AF_LRN_DIS]                        =  "LRN_DIS",
	[VCAP_AF_MASK_MODE]                      =  "MASK_MODE",
	[VCAP_AF_MATCH_ID]                       =  "MATCH_ID",
	[VCAP_AF_MATCH_ID_MASK]                  =  "MATCH_ID_MASK",
	[VCAP_AF_MIRROR_PROBE]                   =  "MIRROR_PROBE",
	[VCAP_AF_PIPELINE_FORCE_ENA]             =  "PIPELINE_FORCE_ENA",
	[VCAP_AF_PIPELINE_PT]                    =  "PIPELINE_PT",
	[VCAP_AF_POLICE_ENA]                     =  "POLICE_ENA",
	[VCAP_AF_POLICE_IDX]                     =  "POLICE_IDX",
	[VCAP_AF_PORT_MASK]                      =  "PORT_MASK",
	[VCAP_AF_RT_DIS]                         =  "RT_DIS",
};

/* VCAPs */
const struct vcap_info sparx5_vcaps[] = {
	[VCAP_TYPE_IS2] = {
		.name = "is2",
		.rows = 256,
		.sw_count = 12,
		.sw_width = 52,
		.sticky_width = 1,
		.act_width = 110,
		.default_cnt = 73,
		.require_cnt_dis = 0,
		.version = 1,
		.keyfield_set = is2_keyfield_set,
		.keyfield_set_size = ARRAY_SIZE(is2_keyfield_set),
		.actionfield_set = is2_actionfield_set,
		.actionfield_set_size = ARRAY_SIZE(is2_actionfield_set),
		.keyfield_set_map = is2_keyfield_set_map,
		.keyfield_set_map_size = is2_keyfield_set_map_size,
		.actionfield_set_map = is2_actionfield_set_map,
		.actionfield_set_map_size = is2_actionfield_set_map_size,
		.keyfield_set_typegroups = is2_keyfield_set_typegroups,
		.actionfield_set_typegroups = is2_actionfield_set_typegroups,
	},
};

const struct vcap_statistics sparx5_vcap_stats = {
	.name = "sparx5",
	.count = 1,
	.keyfield_set_names = vcap_keyfield_set_names,
	.actionfield_set_names = vcap_actionfield_set_names,
	.keyfield_names = vcap_keyfield_names,
	.actionfield_names = vcap_actionfield_names,
};
