#!/usr/bin/env python

#
# Seccomp Library test program
#
# Copyright (c) 2012 Red Hat <pmoore@redhat.com>
# Author: Paul Moore <paul@paul-moore.com>
#

#
# This library is free software; you can redistribute it and/or modify it
# under the terms of version 2.1 of the GNU Lesser General Public License as
# published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
# for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this library; if not, see <http://www.gnu.org/licenses>.
#

import argparse
import errno
import sys

import util

from seccomp import *

def test(args):
    set_api(3)

    f = SyscallFilter(KILL)
    f.add_rule(ALLOW, "read")
    f.add_rule(LOG, "rt_sigreturn")
    f.add_rule(ERRNO(errno.EPERM), "write")
    f.add_rule(TRAP, "close")
    f.add_rule(TRACE(1234), "open")
    f.add_rule(KILL_PROCESS, "stat")
    return f

args = util.get_opt()
ctx = test(args)
util.filter_output(args, ctx)

# kate: syntax python;
# kate: indent-mode python; space-indent on; indent-width 4; mixedindent off;
