/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * (C) Copyright 2023 Texas Instruments Incorporated - https://www.ti.com/
 * Nikhil M Jain, n-jain1@ti.com
 *
 * based on the linux tidss driver, which is
 *
 * Copyright (C) 2016-2018 Texas Instruments Incorporated - https://www.ti.com/
 * Author: Jyri Sarha <jsarha@ti.com>
 */

#ifndef __TIDSS_REGS_H
#define __TIDSS_REGS_H

enum dss_common_regs {
	NOT_APPLICABLE_OFF = 0,
	DSS_REVISION_OFF,
	DSS_SYSCONFIG_OFF,
	DSS_SYSSTATUS_OFF,
	DSS_IRQ_EOI_OFF,
	DSS_IRQSTATUS_RAW_OFF,
	DSS_IRQSTATUS_OFF,
	DSS_IRQENABLE_SET_OFF,
	DSS_IRQENABLE_CLR_OFF,
	DSS_VID_IRQENABLE_OFF,
	DSS_VID_IRQSTATUS_OFF,
	DSS_VP_IRQENABLE_OFF,
	DSS_VP_IRQSTATUS_OFF,
	WB_IRQENABLE_OFF,
	WB_IRQSTATUS_OFF,
	DSS_GLOBAL_MFLAG_ATTRIBUTE_OFF,
	DSS_GLOBAL_OUTPUT_ENABLE_OFF,
	DSS_GLOBAL_BUFFER_OFF,
	DSS_CBA_CFG_OFF,
	DSS_DBG_CONTROL_OFF,
	DSS_DBG_STATUS_OFF,
	DSS_CLKGATING_DISABLE_OFF,
	DSS_SECURE_DISABLE_OFF,
	FBDC_REVISION_1_OFF,
	FBDC_REVISION_2_OFF,
	FBDC_REVISION_3_OFF,
	FBDC_REVISION_4_OFF,
	FBDC_REVISION_5_OFF,
	FBDC_REVISION_6_OFF,
	FBDC_COMMON_CONTROL_OFF,
	FBDC_CONSTANT_COLOR_0_OFF,
	FBDC_CONSTANT_COLOR_1_OFF,
	DSS_CONNECTIONS_OFF,
	DSS_MSS_VP1_OFF,
	DSS_MSS_VP3_OFF,
	DSS_COMMON_REG_TABLE_LEN,
};

/*
 * dss_common_regmap should be defined as const u16 * and pointing
 * to a valid dss common register map for the platform, before the
 * macros bellow can be used.
 */

#define REG(r) (dss_common_regmap[r ## _OFF])

#define DSS_REVISION			REG(DSS_REVISION)
#define DSS_SYSCONFIG			REG(DSS_SYSCONFIG)
#define DSS_SYSSTATUS			REG(DSS_SYSSTATUS)
#define DSS_IRQ_EOI			REG(DSS_IRQ_EOI)
#define DSS_IRQSTATUS_RAW		REG(DSS_IRQSTATUS_RAW)
#define DSS_IRQSTATUS			REG(DSS_IRQSTATUS)
#define DSS_IRQENABLE_SET		REG(DSS_IRQENABLE_SET)
#define DSS_IRQENABLE_CLR		REG(DSS_IRQENABLE_CLR)
#define DSS_VID_IRQENABLE(n)		(REG(DSS_VID_IRQENABLE) + (n) * 4)
#define DSS_VID_IRQSTATUS(n)		(REG(DSS_VID_IRQSTATUS) + (n) * 4)
#define DSS_VP_IRQENABLE(n)		(REG(DSS_VP_IRQENABLE) + (n) * 4)
#define DSS_VP_IRQSTATUS(n)		(REG(DSS_VP_IRQSTATUS) + (n) * 4)
#define WB_IRQENABLE			REG(WB_IRQENABLE)
#define WB_IRQSTATUS			REG(WB_IRQSTATUS)

#define DSS_GLOBAL_MFLAG_ATTRIBUTE	REG(DSS_GLOBAL_MFLAG_ATTRIBUTE)
#define DSS_GLOBAL_OUTPUT_ENABLE	REG(DSS_GLOBAL_OUTPUT_ENABLE)
#define DSS_GLOBAL_BUFFER		REG(DSS_GLOBAL_BUFFER)
#define DSS_CBA_CFG			REG(DSS_CBA_CFG)
#define DSS_DBG_CONTROL		REG(DSS_DBG_CONTROL)
#define DSS_DBG_STATUS		REG(DSS_DBG_STATUS)
#define DSS_CLKGATING_DISABLE		REG(DSS_CLKGATING_DISABLE)
#define DSS_SECURE_DISABLE		REG(DSS_SECURE_DISABLE)

#define FBDC_REVISION_1			REG(FBDC_REVISION_1)
#define FBDC_REVISION_2			REG(FBDC_REVISION_2)
#define FBDC_REVISION_3			REG(FBDC_REVISION_3)
#define FBDC_REVISION_4			REG(FBDC_REVISION_4)
#define FBDC_REVISION_5			REG(FBDC_REVISION_5)
#define FBDC_REVISION_6			REG(FBDC_REVISION_6)
#define FBDC_COMMON_CONTROL		REG(FBDC_COMMON_CONTROL)
#define FBDC_CONSTANT_COLOR_0		REG(FBDC_CONSTANT_COLOR_0)
#define FBDC_CONSTANT_COLOR_1		REG(FBDC_CONSTANT_COLOR_1)
#define DSS_CONNECTIONS		REG(DSS_CONNECTIONS)
#define DSS_MSS_VP1			REG(DSS_MSS_VP1)
#define DSS_MSS_VP3			REG(DSS_MSS_VP3)

/* VID */

#define DSS_VID_ACCUH_0		0x0
#define DSS_VID_ACCUH_1		0x4
#define DSS_VID_ACCUH2_0		0x8
#define DSS_VID_ACCUH2_1		0xc
#define DSS_VID_ACCUV_0		0x10
#define DSS_VID_ACCUV_1		0x14
#define DSS_VID_ACCUV2_0		0x18
#define DSS_VID_ACCUV2_1		0x1c
#define DSS_VID_ATTRIBUTES		0x20
#define DSS_VID_ATTRIBUTES2		0x24
#define DSS_VID_BA_0			0x28
#define DSS_VID_BA_1			0x2c
#define DSS_VID_BA_UV_0		0x30
#define DSS_VID_BA_UV_1		0x34
#define DSS_VID_BUF_SIZE_STATUS	0x38
#define DSS_VID_BUF_THRESHOLD		0x3c
#define DSS_VID_CSC_COEF(n)		(0x40 + (n) * 4)

#define DSS_VID_FIRH			0x5c
#define DSS_VID_FIRH2			0x60
#define DSS_VID_FIRV			0x64
#define DSS_VID_FIRV2			0x68

#define DSS_VID_FIR_COEFS_H0		0x6c
#define DSS_VID_FIR_COEF_H0(phase)	(0x6c + (phase) * 4)
#define DSS_VID_FIR_COEFS_H0_C	0x90
#define DSS_VID_FIR_COEF_H0_C(phase)	(0x90 + (phase) * 4)

#define DSS_VID_FIR_COEFS_H12		0xb4
#define DSS_VID_FIR_COEF_H12(phase)	(0xb4 + (phase) * 4)
#define DSS_VID_FIR_COEFS_H12_C	0xf4
#define DSS_VID_FIR_COEF_H12_C(phase)	(0xf4 + (phase) * 4)

#define DSS_VID_FIR_COEFS_V0		0x134
#define DSS_VID_FIR_COEF_V0(phase)	(0x134 + (phase) * 4)
#define DSS_VID_FIR_COEFS_V0_C	0x158
#define DSS_VID_FIR_COEF_V0_C(phase)	(0x158 + (phase) * 4)

#define DSS_VID_FIR_COEFS_V12		0x17c
#define DSS_VID_FIR_COEF_V12(phase)	(0x17c + (phase) * 4)
#define DSS_VID_FIR_COEFS_V12_C	0x1bc
#define DSS_VID_FIR_COEF_V12_C(phase)	(0x1bc + (phase) * 4)

#define DSS_VID_GLOBAL_ALPHA		0x1fc
#define DSS_VID_K2G_IRQENABLE		0x200 /* K2G */
#define DSS_VID_K2G_IRQSTATUS		0x204 /* K2G */
#define DSS_VID_MFLAG_THRESHOLD	0x208
#define DSS_VID_PICTURE_SIZE		0x20c
#define DSS_VID_PIXEL_INC		0x210
#define DSS_VID_K2G_POSITION		0x214 /* K2G */
#define DSS_VID_PRELOAD		0x218
#define DSS_VID_ROW_INC		0x21c
#define DSS_VID_SIZE			0x220
#define DSS_VID_BA_EXT_0		0x22c
#define DSS_VID_BA_EXT_1		0x230
#define DSS_VID_BA_UV_EXT_0		0x234
#define DSS_VID_BA_UV_EXT_1		0x238
#define DSS_VID_CSC_COEF7		0x23c
#define DSS_VID_ROW_INC_UV		0x248
#define DSS_VID_CLUT			0x260
#define DSS_VID_SAFETY_ATTRIBUTES	0x2a0
#define DSS_VID_SAFETY_CAPT_SIGNATURE	0x2a4
#define DSS_VID_SAFETY_POSITION	0x2a8
#define DSS_VID_SAFETY_REF_SIGNATURE	0x2ac
#define DSS_VID_SAFETY_SIZE		0x2b0
#define DSS_VID_SAFETY_LFSR_SEED	0x2b4
#define DSS_VID_LUMAKEY		0x2b8
#define DSS_VID_DMA_BUFSIZE		0x2bc /* J721E */

/* OVR */

#define DSS_OVR_CONFIG		0x0
#define DSS_OVR_VIRTVP		0x4 /* J721E */
#define DSS_OVR_DEFAULT_COLOR		0x8
#define DSS_OVR_DEFAULT_COLOR2	0xc
#define DSS_OVR_TRANS_COLOR_MAX	0x10
#define DSS_OVR_TRANS_COLOR_MAX2	0x14
#define DSS_OVR_TRANS_COLOR_MIN	0x18
#define DSS_OVR_TRANS_COLOR_MIN2	0x1c
#define DSS_OVR_ATTRIBUTES(n)		(0x20 + (n) * 4)
#define DSS_OVR_ATTRIBUTES2(n)	(0x34 + (n) * 4) /* J721E */
/* VP */

#define  DSS_VP_CONFIG				0x0
#define DSS_VP_CONTROL			0x4
#define DSS_VP_CSC_COEF0			0x8
#define DSS_VP_CSC_COEF1			0xc
#define DSS_VP_CSC_COEF2			0x10
#define DSS_VP_DATA_CYCLE_0			0x14
#define DSS_VP_DATA_CYCLE_1			0x18
#define DSS_VP_K2G_GAMMA_TABLE		0x20 /* K2G */
#define DSS_VP_K2G_IRQENABLE			0x3c /* K2G */
#define DSS_VP_K2G_IRQSTATUS			0x40 /* K2G */
#define DSS_VP_DATA_CYCLE_2			0x1c
#define DSS_VP_LINE_NUMBER			0x44
#define DSS_VP_POL_FREQ			0x4c
#define DSS_VP_SIZE_SCREEN			0x50
#define DSS_VP_TIMING_H			0x54
#define DSS_VP_TIMING_V			0x58
#define DSS_VP_CSC_COEF3			0x5c
#define DSS_VP_CSC_COEF4			0x60
#define DSS_VP_CSC_COEF5			0x64
#define DSS_VP_CSC_COEF6			0x68
#define DSS_VP_CSC_COEF7			0x6c
#define DSS_VP_SAFETY_ATTRIBUTES_0		0x70
#define DSS_VP_SAFETY_ATTRIBUTES_1		0x74
#define DSS_VP_SAFETY_ATTRIBUTES_2		0x78
#define DSS_VP_SAFETY_ATTRIBUTES_3		0x7c
#define DSS_VP_SAFETY_CAPT_SIGNATURE_0	0x90
#define DSS_VP_SAFETY_CAPT_SIGNATURE_1	0x94
#define DSS_VP_SAFETY_CAPT_SIGNATURE_2	0x98
#define DSS_VP_SAFETY_CAPT_SIGNATURE_3	0x9c
#define DSS_VP_SAFETY_POSITION_0		0xb0
#define DSS_VP_SAFETY_POSITION_1		0xb4
#define DSS_VP_SAFETY_POSITION_2		0xb8
#define DSS_VP_SAFETY_POSITION_3		0xbc
#define DSS_VP_SAFETY_REF_SIGNATURE_0		0xd0
#define DSS_VP_SAFETY_REF_SIGNATURE_1		0xd4
#define DSS_VP_SAFETY_REF_SIGNATURE_2		0xd8
#define DSS_VP_SAFETY_REF_SIGNATURE_3		0xdc
#define DSS_VP_SAFETY_SIZE_0			0xf0
#define DSS_VP_SAFETY_SIZE_1			0xf4
#define DSS_VP_SAFETY_SIZE_2			0xf8
#define DSS_VP_SAFETY_SIZE_3			0xfc
#define DSS_VP_SAFETY_LFSR_SEED		0x110
#define DSS_VP_GAMMA_TABLE			0x120
#define DSS_VP_DSS_OLDI_CFG			0x160
#define DSS_VP_DSS_OLDI_STATUS		0x164
#define DSS_VP_DSS_OLDI_LB			0x168
#define DSS_VP_DSS_MERGE_SPLIT		0x16c /* J721E */
#define DSS_VP_DSS_DMA_THREADSIZE		0x170 /* J721E */
#define DSS_VP_DSS_DMA_THREADSIZE_STATUS	0x174 /* J721E */

/*
 * OLDI IO_CTRL register offsets. On AM654 the registers are found
 * from CTRL_MMR0, there the syscon regmap should map 0x14 bytes from
 * CTRLMMR0P1_OLDI_DAT0_IO_CTRL to CTRLMMR0P1_OLDI_CLK_IO_CTRL
 * register range.
 */
#define OLDI_DAT0_IO_CTRL			0x00
#define OLDI_DAT1_IO_CTRL			0x04
#define OLDI_DAT2_IO_CTRL			0x08
#define OLDI_DAT3_IO_CTRL			0x0C
#define OLDI_CLK_IO_CTRL			0x10

/* Only for AM625 OLDI TX */
#define OLDI_PD_CTRL				0x100
#define OLDI_LB_CTRL				0x104

#define OLDI_BANDGAP_PWR			BIT(8)
#define OLDI_PWRDN_TX				BIT(8)
#define OLDI0_PWRDN_TX				BIT(0)
#define OLDI1_PWRDN_TX				BIT(1)

/* Supported plane formats */
#define DSS_FORMAT_ARGB4444 0x0
#define DSS_FORMAT_ABGR4444 0x1
#define DSS_FORMAT_RGBA4444 0x2

#define DSS_FORMAT_RGB565 0x3
#define DSS_FORMAT_BGR565 0x4

#define DSS_FORMAT_ARGB1555 0x5
#define DSS_FORMAT_ABGR1555 0x6

#define DSS_FORMAT_ARGB8888 0x7
#define DSS_FORMAT_ABGR8888 0x8
#define DSS_FORMAT_RGBA8888 0x9
#define DSS_FORMAT_BGRA8888 0xa

#define DSS_FORMAT_RGB888 0xb
#define DSS_FORMAT_BGR888 0xc

#define DSS_FORMAT_ARGB2101010 0xe
#define DSS_FORMAT_ABGR2101010 0xf

#define DSS_FORMAT_XRGB4444 0x20
#define DSS_FORMAT_XBGR4444 0x21
#define DSS_FORMAT_RGBX4444 0x22

#define DSS_FORMAT_XRGB1555 0x25
#define DSS_FORMAT_XBGR1555 0x26

#define DSS_FORMAT_XRGB8888 0x27
#define DSS_FORMAT_XBGR8888 0x28
#define DSS_FORMAT_RGBX8888 0x29
#define DSS_FORMAT_BGRX8888 0x2a

#define DSS_FORMAT_XRGB2101010 0x2e,
#define DSS_FORMAT_XBGR2101010 0x2f,

#endif /* __TIDSS_DSS_REGS_H */
