// --- BEGIN COPYRIGHT BLOCK ---
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; version 2 of the License.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
//
// (C) 2007 Red Hat, Inc.
// All rights reserved.
// --- END COPYRIGHT BLOCK ---
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.apps.CMS;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ca.ICertificateAuthority;

import netscape.security.x509.X509CertImpl;

/**
 * This class represents an abstract class for CA enrollment
 * constraint.
 */
public abstract class CAEnrollConstraint extends EnrollConstraint {

    /**
     * Constructs a CA enrollment constraint.
     */
    public CAEnrollConstraint() {
        super();
    }

    /**
     * Retrieves the CA certificate.
     */
    public X509CertImpl getCACert() throws EBaseException {
        ICertificateAuthority ca = (ICertificateAuthority)
                CMS.getSubsystem(CMS.SUBSYSTEM_CA);
        X509CertImpl caCert = ca.getCACert();

        return caCert;
    }
}
