/*
 *
 *  Kepas - KDE Easy Publish and Share
 *
 *  Copyright (C) 2008  Tom Patzig <tpatzig@suse.de>
 *
 *  This file is part of kepas.
 *
 *  kepas is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  kepas is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with kepas; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
*/

#include "requestClipboard.h"

RequestClipboard::RequestClipboard(QWidget* parent,QString hostname, int port, QString user) : m_hostname(hostname), m_port(port), m_user(user)
{
         http = new QHttp(hostname,port);

	 QString uuid = QUuid::createUuid().toString();

         m_parent = parent;
         requestGet = new QHttpRequestHeader("GET", "/");
         requestGet->setValue("Request","GetClip");
         requestGet->setValue("UserName",user);
         requestGet->setValue("Type","Clipboard");
	 requestGet->setValue("SessionID",uuid);
	 
         requestGet->setValue("Host",QString(hostname + ":" + QString::number(port)));

         connect(http, SIGNAL(requestFinished(int,bool)),this, SLOT(slotRequestFinished(int, bool)));
}


RequestClipboard::~RequestClipboard()
{



}

void RequestClipboard::sendRequest()
{
         
//         connect(http, SIGNAL(responseHeaderReceived (const QHttpResponseHeader&)), this, SLOT(slotGetResponseReceived(const QHttpResponseHeader&)));
	 
//	 connect(http, SIGNAL(readyRead(const QHttpResponseHeader&)), this, SLOT(slotGetResponseReceived(const QHttpResponseHeader&)));	 
         
  //       http->request(*requestGet);

}



void RequestClipboard::slotGetResponseReceived(const QHttpResponseHeader& resp)
{

//         disconnect(http, SIGNAL(responseHeaderReceived (const QHttpResponseHeader&)), this, SLOT(slotGetResponseReceived(const QHttpResponseHeader&)));

	 disconnect(http, SIGNAL(readyRead(const QHttpResponseHeader&)), this, SLOT(slotGetResponseReceived(const QHttpResponseHeader&)));	 
//         qDebug() << "Response Status Code " << resp.statusCode();
	 if (resp.statusCode() == 200) {
//		 qDebug() << "Received Clipboard: " << http->readAll().data();
		 QString clip = http->readAll().data();
	 	 QStringList cliplist = clip.split("##");
		 QString msg = cliplist.join("\n");

		 KMessageBox::information(this,msg,"Clipboard from " + m_user);

	 }
		
        
}


void RequestClipboard::slotRequestFinished(int id, bool error)
{
        if (error) {
                errorMsg = new QErrorMessage(m_parent);
                errorMsg->showMessage(http->errorString());
                http->abort();
        }

}

