/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "tirage.h"

int tirage::nb_plaques=6;
int tirage::compte_minimal=100;
int tirage::compte_maximal=999;
map<plaque, int> tirage::ref;

//les plaques du tirage deviennent la rfrence des plaques autorises
void tirage::utiliser_comme_ref() {
	ref=tab;
}

//fonction renvoyant la taille d'un tirage
int tirage::taille() const {
	int resultat=0;
	map<plaque, int>::const_iterator it;
	
	for(it=tab.begin();it!=tab.end();it++){
		resultat=resultat+(it->second);
	}
	
	return resultat;
}

//renvoie true si le tirage est valable (pas trop de plaques de chaque sorte).
bool tirage::est_valable() {
	map<plaque, int>::const_iterator it;
	for(it=tab.begin();it!=tab.end();it++) {
		if( (it->second) > ref[it->first] ) return false;
	}
	
	return true;
}

//renvoie le poids d'un tirage relativement au nb de couples dans ce tirage,
//en supposant que ce tirage est un tirage possible dans le jeu (pas de triplettes ou plus)
int tirage::coefficient() const {
	int resultat=1;
	
	map<plaque, int>::const_iterator it;
	
	for(it=tab.begin();it!=tab.end();it++){
		if(it->second==1 && it->first<11){
			resultat=resultat*2;
		}
	}
	
	return resultat;
}

//--------------------------------------------------------------
//Oprations sur les tirages
//--------------------------------------------------------------
bool tirage::operator!=(const tirage& a) const{
	return (tab!=a.tab);
}

bool tirage::operator==(const tirage& a) const {
	return (tab==a.tab);
}

bool tirage::operator<(const tirage& a) const {
	return (tab<a.tab);
}

tirage tirage::operator+(const tirage& a) const {
	tirage resultat=a;
	map<plaque, int>::const_iterator it;
	for(it=tab.begin();it!=tab.end();it++){
		resultat.tab[it->first] += (it->second);
	}
	return resultat;
}

//oprateur d'inclusion au sens large
//par exemple 1;1;4 est inclus dans 1;1;3;4;100 mais pas dans 1;4;10;50
bool tirage::inclus_dans(tirage a) const {
	map<plaque, int>::const_iterator it;
	for(it=tab.begin();it!=tab.end();it++){
		if ((it->second) > a.tab[it->first]){
			return false;
		}
	}
	return true;
}

//fonction prenant un tirage en argument, et renvoyant un vecteur
//contenant les sous-tirages de ce tirage, tris dans un ordre "intressant"
vector<tirage> tirage::calcul_sous_tirages() const {
	tirage tvide;
	
	//cre un vecteur contenant uniquement le tirage vide
	vector<tirage> v(1,tvide);
	
	map<plaque, int>::const_iterator i;
	for(i=tab.begin();i!=tab.end();i++){	//voir algorithme dtaill sur le site
		int a=v.size();		//attention, la taille de v varie tout au long de la boucle indexe par j
		int j; int k;
		for(j=1;j<=i->second;j++){
			for(k=0;k<a;k++){
				tirage temp=v[k];
				temp.tab[i->first]=j;
				v.push_back(temp);
			}
		}
	}
	
	return v;
}

//--------------------------------------------------------------
//Fonction donnant la position d'un tirage dans un vecteur de tirages
//--------------------------------------------------------------
int tirage::trouve_dans(const vector<tirage> &v) const{
	int resultat=0;
	
	while (v[resultat]!=*this){
		resultat++;
	}
	
	return resultat;
}

//--------------------------------------------------------------
//Fonctions d'affichage
//--------------------------------------------------------------

//fonction affichant un tirage
ostream& operator<<(ostream& ostr, const tirage& t) {
	
	if (t.tab.size()==0) {
		return ostr << "vide";
	}
	
	map<plaque, int>::const_iterator i; int j;
	for(i=t.tab.begin(); i!=t.tab.end(); i++){
		for(j=0; j<(i->second); j++){
			ostr << (int) (i->first) << ".";
		}
	}
	
	return ostr; //<< "\b";
}

//fonction affichant un vecteur de tirages.
ostream& operator<<(ostream& ostr, const vector<tirage>& v){
	int taille=v.size(); int i;
	
	ostr << "[";
	for(i=0; i<taille-1; i++) {
		ostr << v[i] << " ; ";
	}
	ostr << v[taille-1];
	ostr << "]";
	
	return ostr;
}

//cre les 134596 faons de choisir 6 nb parmi 0;1;2;...;23
list<pseudo_tirage> cree_liste_pseudo(){
	
	//initialisation de v
	pseudo_tirage v;
	for(int i=0;i<tirage::nb_plaques;i++){
		v.push_back(i);
	}
	
	//initialisation de la liste
	list<pseudo_tirage> liste;
	int pos=tirage::nb_plaques-1;
	bool pas_termine=true;
	
	while(pas_termine){
		while(v[tirage::nb_plaques-1]<24){
			liste.push_back(v);
			v[tirage::nb_plaques-1]++;
		}
	
		while(pas_termine && v[pos]==19+pos){
			pos--;
			if(pos>=0){
				v[pos]++;
			}
			else{
				pas_termine=false; pos++;
			}
		}
		
		if(pas_termine){
			for(int j=pos+1;j<tirage::nb_plaques;j++){
				v[j]=v[pos]+j-pos;
			}
		}
		
		pos=tirage::nb_plaques-1;
	}
	
	//cout<<"nb de listes trouves : " << liste.size() << endl;	//pour vrifier que l'algo est juste
	return liste;
}

//transforme un pseudo-tirage en tirage
tirage pseudo_en_tirage(pseudo_tirage p){
	
	tirage t; int i;
	
	for(i=0;i<tirage::nb_plaques;i++){
		switch (p[i]){
			case 23: t.tab[100]=1; break;
			case 22: t.tab[75]=1; break;
			case 21: t.tab[50]=1; break;
			case 20: t.tab[25]=1; break;
			default: t.tab[1+p[i]/2]++; break;
		}
	}
	
	return t;
}

//stocke les 13243 tirages diffrents
set<tirage> tous_les_tirages(){
	
	set<tirage> resultat;
	
	list<pseudo_tirage> liste_pseudo=cree_liste_pseudo();
	list<pseudo_tirage>::iterator PT;
	
	for(PT=liste_pseudo.begin();PT!=liste_pseudo.end();PT++){
		resultat.insert(pseudo_en_tirage(*PT));
	}
	
	return resultat;
}


//fonction renvoyant la plus petite plaque suprieure  une plaque p, et disponible une fois enleves les plaques du tirage t
plaque plus_petite_plaque_sup(tirage t,plaque p) {
	plaque resultat=augmente_plaque(p);
	while ( (t.tab[resultat]==2 && resultat<=10) || (t.tab[resultat]==1 && resultat >10) ){
		resultat=augmente_plaque(resultat);
	}
	//if(resultat<p) resultat=0;  //commenter si on autorise le bouclage
	return resultat;
}

//fonction renvoyant la plus petite plaque infrieure  une plaque p, et disponible une fois enleves les plaques du tirage t
plaque plus_petite_plaque_inf(tirage t,plaque p) {
	plaque resultat=diminue_plaque(p);
	while ( (t.tab[resultat]==2 && resultat<=10) || (t.tab[resultat]==1 && resultat >10) ){
		resultat=diminue_plaque(resultat);
	}
	//if(resultat>p) resultat=0;  //commenter si on autorise le bouclage
	return resultat;
}

//fonction donnant la plaque juste plus grande que la plaque p (avec bouclage)
plaque augmente_plaque(plaque p) {
	map<plaque, int>::iterator it;
	it=tirage::ref.find(p);
	if(it!=tirage::ref.end()) {
		//on passe  la plaque suivante
		it++;
		
		//retour  la premire plaque si on est arriv en fin de liste
		/*if(it==tirage::ref.end()) {
			it=tirage::ref.begin();
		}*/
	}
	
	if(it!=tirage::ref.end()) {	//nouveau test (cas de la liste vide)
		return it->first;
	} else	{
		//cas d'erreur -  rgler un jour
		return 0;
	}
}

//fonction donnant la plaque juste plus petite que la plaque p (avec bouclage)
plaque diminue_plaque(plaque p) {
	map<plaque, int>::iterator it;
	it=tirage::ref.find(p);
	if(it!=tirage::ref.end()) {
		//retour  la premire plaque si on est arriv en fin de liste
		/*if(it==tirage::ref.begin()) {
			it=tirage::ref.end();
		}*/
		//on passe  la plaque precedente
		it--;
	}
	
	if(it!=tirage::ref.end()) {	//nouveau test (cas de la liste vide)
		return it->first;
	} else	{
		//cas d'erreur -  rgler un jour
		return 0;
	}
}
