/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PRINCIPAL_H
#define PRINCIPAL_H

#include "tirage.h"
#include "jeu.h"
#include "widgetpopup.h"
#include "widgetplaque.h"
#include "widgetoptions.h"
#include "widgetresolution.h"
#include "global.h"
#include "widgethorloge.h"

#include <QMainWindow>
#include <QWidget>
#include <QString>

class QSignalMapper;
class QTextEdit;
class QLabel;
class QPixmap;

class Principal : public QMainWindow, policesQt {
	Q_OBJECT
	
  public:
	Principal( QWidget *parent=0 );
	
	QString texte_version, texte_renard_repos, texte_renard_ceb, texte_renard_pds, texte_statut_attente,
	texte_statut_en_cours, texte_statut_duree, texte_renard_gagne, texte_renard_perdu;
	
	//la classe jeu ne doit pas tre dtruite en sortie de resoudre (thread actif)
	jeu *J;
	
	//divers paramtres lis au calcul
	tirage t;
	vector<plaque> liste_des_plaques;
	vector<int> liste_des_chiffres;
	
	//paramtres pour dterminer l'tat dans lequel se trouve l'application
	//true si le joueur est en train de rsoudre un compte en temps limit
	bool jeu_en_cours;
	//mis  true si le joueur n'a pas eu le temps de trouver la solution
	bool trop_tard;
	
	//pour savoir combien de temps le calcul a pris
	QTime *heure;
	
	//widgets parents
	QWidget *hbox_res;
	QTextEdit *textEditC;
	WidgetResolution *resol;
	
	//diffrents widgets
	QLabel *texte_renard;
	WidgetHorloge *horloge;
	QStatusBar *BarreStatut;
	
	QPushButton *pbJouer, *pbRes, *pbAlea, *pbZero;
	
	//image du renard
	QLabel *pixmapLabelRenard;
	QPixmap *renard_normal, *renard_heureux, *renard_triste;
	
	//mapper pour le signal de lecture d'un fichier texte
	QSignalMapper *lireTexte_Mapper;

  public slots:
	//fonctions d'ouverture des fentres des menus
	void options();
	void lire_texte(int num);
	
	//fonctions appeles lorsque l'on pousse un des boutons
	void jouer();
	void resoudre();
	void aleatoire();
	void mise_a_zero();
	
	//fonctions pour le lancement et la fin d'un calcul
	void lancement_calcul();
	void fin_calcul();
	
	//fonctions de mise  jour de l'affichage
	void update_affichage_plaques();
	void update_affichage_compte();
	void reinit_statut();
	void reinit_plaques_tirage(bool);
	
	//fonctions d'affichage des rsultats
	void victoire();
	void defaite();
	void affiche_temps_de_calcul();
	void affiche_solutions();
	void renard_apres_calcul();
	void renard_apres_jeu(bool);
	
	//fonctions appeles lors de la modification d'une plaque
	void compte_change(int,bool);
	void tirage_change(int,bool);
	
  signals :
	//signal de rafraichissement
	void refresh(int, int); //num de widget a rafraichir et valeur
	void plaqueReglable(bool);
	void changeEtat(int, int);
	void bloque_module(bool);	//pour bloquer!dbloquer le module de rsolution
};

#endif
