/*
 * libspe - A wrapper library to adapt the JSRE SPU usage model to SPUFS
 * Copyright (C) 2005 IBM Corp.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License,
 * or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 *  License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   along with this library; if not, write to the Free Software Foundation,
 *   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#define _GNU_SOURCE
#include <errno.h>
#include <libspe.h>
#include <pthread.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <sys/mman.h>

#include "spe.h"

#define __PRINTF(fmt, args...) { fprintf(stderr,fmt , ## args); }
#ifdef DEBUG
#define DEBUG_PRINTF(fmt, args...) __PRINTF(fmt , ## args)
#else
#define DEBUG_PRINTF(fmt, args...)
#endif

#define SPE_SIGNAL_REG 0x0C

unsigned int *spe_signal_address(speid_t speid, int signo)
{
	struct thread_store *thread_store = speid;
	int fd;
	void **base_addr;
	off_t offset;

	if (signo != 1 && signo != 2){
		perror("spe_signal_address: only signal 1 and 2 are valid");
		errno = EINVAL;
		return MAP_FAILED;
	}

	if (signo == 1){
		fd = thread_store->fd_sig1;
		base_addr = &thread_store->signal1_mmap_base;
		offset = 0x14000;
	}
	else {
		fd = thread_store->fd_sig2;
		base_addr = &thread_store->signal2_mmap_base;
		offset = 0x1c000;
	}

	if ( base_addr == MAP_FAILED ){
		*base_addr = do_spe_map_ps_area(thread_store, offset, fd, 0x1000);
		if ( *base_addr == MAP_FAILED ){	
			perror("spe_signal_address: internal error. cant map signal file.");
			errno = EIO;
			return MAP_FAILED;
		}
	}

	return (*base_addr)+0x0C;
}

