open Viz_types

type layout = Viz_types.cgraph
type layout_params = {
    box_w     : float ;
    box_h     : float ;
    char_width : float ;
    lr_layout : bool ;
    dot_program : string ;
  }
type t

type done_cb = [`LAYOUT_DONE | `LAYOUT_ERROR of string] -> unit
val make : 
  agraph -> query -> layout_params -> 
  <push : string -> unit; pop : unit -> unit; ..> ->
  done_cb -> t
    (* spawn dot *)

exception Not_yet
val get_layout : t -> layout
val abort_layout : t -> unit

val get_query : t -> query
val get_ids   : t -> string list

val mem : t -> string -> bool
val get_ancestors : t -> string -> string list

val get_node     : t -> string -> string * c_node        (* query window *)
val get_parents  : t -> string -> (string * c_node) list (* keyboard nav *)
val get_children : t -> string -> (string * c_node) list (* keyboard nav *)
val get_siblings : t -> string -> (string * c_node) list (* keyboard nav *)
