# Release Process

This document outlines the steps involved in the release process for the NGINX Prometheus Exporter.

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
## Table of Contents

- [Versioning](#versioning)
- [Release Planning and Development](#release-planning-and-development)
- [Releasing a New Version](#releasing-a-new-version)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Versioning

The project follows [Semantic Versioning](https://semver.org/).

## Release Planning and Development

The features that will go into the next release are reflected in the
corresponding [milestone](https://github.com/nginx/nginx-prometheus-exporter/milestones). Refer to
the [Issue Lifecycle](/ISSUE_LIFECYCLE.md) document for information on issue creation and assignment to releases.

## Releasing a New Version

1. Create an issue to define and track release-related activities. Choose a title that follows the
   format `Release X.Y.Z`.
2. Stop merging any new work into the main branch.
3. Check the release draft under the [GitHub releases](https://github.com/nginx/nginx-prometheus-exporter/releases) page
   to ensure that everything is in order.
4. Create a PR to update the version in the `Makefile` and [README](README.md) to the new version, and any other necessary
   changes.
5. Once the PR is merged, create a new release tag in the format `vX.Y.Z`:

   ```bash
   git tag -a vX.Y.Z -m "Release vX.Y.Z"
   git push origin vX.Y.Z
   ```

   As a result, the CI/CD pipeline will:

   - Build the Docker image and push it to the registries.
   - Publish the release to Snapcraft, Homebrew, Scoop, and Nix.
   - Create a GitHub release with the autogenerated changelog and artifacts attached.
