% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stancode.R
\name{stancode}
\alias{stancode}
\alias{make_stancode}
\title{Stan Code for Bayesian models}
\usage{
stancode(object, ...)

make_stancode(formula, ...)
}
\arguments{
\item{object}{An object whose class will determine which method to apply.
Usually, it will be some kind of symbolic description of the model
form which Stan code should be generated.}

\item{...}{Further arguments passed to the specific method.}

\item{formula}{Synonym of \code{object} for use in \code{make_stancode}.}
}
\value{
Usually, a character string containing the generated Stan code.
  For pretty printing, we recommend the returned object to be of class
  \code{c("character", "brmsmodel")}.
}
\description{
\code{stancode} is a generic function that can be used to
  generate Stan code for Bayesian models. Its original use is
  within the \pkg{brms} package, but new methods for use
  with objects from other packages can be registered to the same generic.
}
\details{
See \code{\link[brms:stancode.default]{stancode.default}} for the default
  method applied for \pkg{brms} models.
  You can view the available methods by typing: \code{methods(stancode)}
  The \code{make_stancode} function is an alias of \code{stancode}.
}
\examples{
stancode(rating ~ treat + period + carry + (1|subject),
         data = inhaler, family = "cumulative")

}
\seealso{
\code{\link{stancode.default}}, \code{\link{stancode.brmsfit}}
}
