//  base class for aligned classes
//  Copyright (C) 2011 Tim Blechmann
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.

#ifndef UTILITIES_ALIGNED_CLASS
#define UTILITIES_ALIGNED_CLASS

#include "malloc_aligned.hpp"

namespace nova {

struct aligned_class
{
    inline void * operator new(std::size_t size)
    {
        return malloc_aligned(size);
    }

    inline void operator delete(void * p)
    {
        free_aligned(p);
    }
};


} /* namespace nova */


#endif /* UTILITIES_ALIGNED_CLASS */
