/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "tree.h"
# include "abs.h"
# include "interfaces.h"

extern int nelvoip;
extern int nsp;


/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | build_quadtree                                                       |
  |         Construction du quadtree                                     |
  |======================================================================| */
void build_quadtree_1d (struct node *arbre, int ndim, int npoinr,int nelray,
		     int *nodray,double *cooray, double *size_min,
		     double dim_boite[])

{
	
    struct element *f1,*f2;
    
  
    int i,nbelt;
    double dx,dy;
    double xmin,xmax,ymin,ymax;
    

    xmin =  1.E10; ymin=  1.E6 ;
    xmax = -1.E10; ymax= -1.E6 ;
    
    for (i=0;i<npoinr;i++)
    {
       xmin = min(*(cooray+i),xmin);
       ymin = min(*(cooray+i+npoinr),ymin);
       xmax = max(*(cooray+i),xmax);
       ymax = max(*(cooray+i+npoinr),ymax);
    }


    dx = xmax-xmin; dy=ymax-ymin;
    xmin -= (dx*0.01); ymin -= (dy*0.01); 
    xmax += (dx*0.01); ymax += (dy*0.01); 
    dx = xmax-xmin; dy=ymax-ymin;
     

    dim_boite[0]=xmin; dim_boite[1]=xmax; 
    dim_boite[2]=ymin; dim_boite[3]=ymax; 

/*    arbre->name = 1; */
    arbre->xc = (xmin+xmax)*0.5;
    arbre->yc = (ymin+ymax)*0.5;
    arbre->sizx = dx*0.5;    
    arbre->sizy = dy*0.5;    
    arbre->lelement = NULL;
    arbre->lfils = NULL;
    *size_min = min(dx,dy);

    f1 = (struct element *)malloc(sizeof(struct element));
    if (f1==NULL) 
       {printf(" ERREUR build_octree : probleme d'allocation memoire\n");
        exit(0);}
    f1->num = 1;
    f1->suivant=NULL;
    arbre->lelement=f1;
    
    for (i=1;i<nelray;i++)
    {
	f2 = (struct element *)malloc(sizeof(struct element));
	if (f2==NULL) 
	  {printf(" ERREUR build_octree : probleme d'allocation memoire\n");
	   exit(0);}
	f2->num = i+1;
	f2->suivant=NULL;
	f1->suivant = f2;
	f1 = f2;
    }
    nbelt = nelray;

    decoupe1d(arbre,nodray,cooray,nelray,npoinr,nbelt,size_min);


    elague_tree(arbre,arbre,4);   

/*    printf("\n\n Arbre apres elaguage\n");
    affiche_tree(arbre,4);   
*/      
}

/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | decoupe2d                                                            |
  |         Construction du quadtree                                     |
  |======================================================================| */
void decoupe1d(struct node *noeud,int *nodray,double *cooray,
	       int nelray,int npoinr,int nbelt,double *size_min)
{

    double xmin[4],xmax[4],ymin[4],ymax[4];
    double x,y,dx,dy ;
    int i,nbfac,nbelt_max;
    struct node *n1,*n2,*noeudi;
    struct child *f1,*f2;
    struct element *elt1;
    
    nbelt_max=max(nelvoip*nsp+10,30);

    if (nbelt>nbelt_max)
    {
      
      x = noeud->xc; y = noeud->yc;
      dx = noeud->sizx; dy = noeud->sizy;

      xmax[0]=xmax[3]= x;
      xmin[1]=xmin[2]= x;
      xmin[0]=xmin[3]= x - dx;
      xmax[1]=xmax[2]= x + dx;

      ymax[2]=ymax[3]= y;
      ymin[0]=ymin[1]= y;
      ymin[2]=ymin[3]= y - dy;
      ymax[0]=ymax[1]= y + dy;


      f1= (struct child *)malloc(sizeof(struct child));
      n1= (struct node *) malloc(sizeof(struct node ));
      if (f1==NULL || n1==NULL) 
	{printf(" ERREUR decoupe : probleme d'allocation memoire\n");
	 exit(0);}

      noeud->lfils = f1;
/*      f1->name = (noeud->name)*10 + 1; */
      f1->fils = n1;
      f1->suivant = NULL;

      for (i=1;i<4;i++)
	  {
	      f2= (struct child *)malloc(sizeof(struct child));
	      n2= (struct node *) malloc(sizeof(struct node ));
	      if (f2==NULL || n2==NULL) 
		{printf(" ERREUR decoupe : probleme d'allocation memoire\n");
		 exit(0);}
	      f1->suivant = f2;
/*	      f2->name = (noeud->name)*10 + i+1; */
	      f2->fils = n2;
	      f2->suivant = NULL;
	      f1 = f2;
	  }


      f1 = noeud->lfils;

      for (i=0;i<4;i++)
	  {
	      noeudi = f1->fils;
/*	      noeudi->name =  (noeud->name)*10 + i+1; */
	      noeudi->xc = (xmin[i]+xmax[i])*0.5;
	      noeudi->yc = (ymin[i]+ymax[i])*0.5;
	      noeudi->sizx = (xmax[i]-xmin[i])*0.5;
	      noeudi->sizy = (ymax[i]-ymin[i])*0.5;
	      *size_min = min(*size_min,noeudi->sizx);
	      *size_min = min(*size_min,noeudi->sizy);
	      noeudi->lfils = NULL;
	      elt1= (struct element *)malloc(sizeof(struct element));
	      if (elt1==NULL) 
		{printf(" ERREUR decoupe : probleme d'allocation memoire\n");
		 exit(0);}
	      noeudi->lelement = elt1;

	      triseg(noeud->lelement,noeudi->lelement,
		     &nbfac,nelray,npoinr,nodray,cooray,
		     noeudi->xc,noeudi->yc,noeudi->sizx,noeudi->sizy);

              if (nbfac != 0)
		  decoupe1d(noeudi,nodray,cooray,nelray,npoinr,nbfac,size_min);
	      else
		  {
		       noeudi->lelement = NULL;
		       free(elt1);
		  }
	      
	      f1 = f1->suivant;
	  }
		  
    }

}

/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | triseg                                                               |
  |         Tri des segments pour les placer dans le quadtree            |
  |======================================================================| */
void triseg( struct element *face_pere, struct element *face_fils, 
	     int *nbfac,int nelray,int npoinr,int *nodray,double *cooray,
	     double xcc,double ycc,double dx,double dy)
{

    int n,prem ;
    double xa,ya,xb,yb;
    struct element *fp1,*ff1,*ff2;

    prem = 1;
    fp1 = face_pere;
    ff1 = face_fils;
    *nbfac = 0;

   do
    {
	 n = *(nodray+fp1->num-1);
	xa = *(cooray+n-1);
	ya = *(cooray+n-1+npoinr);

	 n = *(nodray+fp1->num-1+nelray);
	xb = *(cooray+n-1);
	yb = *(cooray+n-1+npoinr);


	if (seg_in_rectan(xa,ya,xb,yb,xcc,ycc,dx,dy))
	    {
                if (prem)
		    {
			prem = 0;
			ff1->num = fp1->num;
			ff1->suivant = NULL;
		    }
		else
		    {
			ff2= (struct element *)malloc(sizeof(struct element));
			if (ff2==NULL) 
			  {printf(" ERREUR triface : probleme d'allocation memoire\n");
			   exit(0);}
			ff2->num = fp1->num;
			ff2->suivant = NULL;
			ff1->suivant = ff2;
			ff1 = ff2;
		    }
		*nbfac += 1;

	    }

	fp1 = fp1->suivant;

    }while (fp1 != NULL);

   
}

/*|======================================================================|
  | SYRTHES 3.4.3                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | tria_in_rectan                                                       |
  |         Tri des triangles pour les placer dans le quadtree           |
  |======================================================================| */
int seg_in_rectan(double xa,double ya,double xb,double yb,
		   double xcc,double ycc,double dx,double dy)
{

    double xmin,xmax,ymin,ymax;
    double d2;
    double epsi;

    epsi=1.E-5;
    d2=dx+dy; 

    xmin = xcc-dx-epsi; xmax = xcc+dx+epsi;
    ymin = ycc-dy-epsi; ymax = ycc+dy+epsi;

    if (in_rectan (xa,ya,xmin,xmax,ymin,ymax))
	return(1);
    else if (in_rectan(xb,yb,xmin,xmax,ymin,ymax))
	return(1);

    else if (xa>xmax && xb>xmax)
	return(0);
    else if (xa<xmin && xb<xmin)
	return(0);
    else if (ya>ymax && yb>ymax)
	return(0);
    else if (ya<ymin && yb<ymin)
	return(0);

    else
      {
	xa -= xcc; ya -= ycc;
	xb -= xcc; yb -= ycc;

	if (xa+ya<-d2 && xb+yb<-d2)
	    return(0);
	else if (xa+ya>d2  && xb+yb>d2)
	    return(0);
	else if (xa-ya>-d2  && xb-yb>-d2)
	    return(0);
	else if (ya-ya<d2 && yb-yb<d2)
	    return(0);


	else if (seg_rectanx( dx, dy,xa,xb,ya,yb))
	    return(1);
	else if (seg_rectanx(-dx, dy,xa,xb,ya,yb))
	    return(1);
	else if (seg_rectany( dx, dy,xa,xb,ya,yb))
	    return(1);
	else if (seg_rectany( dx,-dy,xa,xb,ya,yb))
	    return(1);
    }

    return(0);
    
}

    

