C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LRAME1
C                       *****************
C
C     --------------------
     *(NDIM,NPOINR,NELRAY)
C     --------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C       1ere LECTURE DU MAILLAGE ELEMENTS FINIS POUR LE RAYONNEMENT    *
C             --> STRUCTURE DE DONNEE ISSUE DE MED                     *
C             (Necessaire pour les dimensionnements de tableaux)       *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : LCOODP,CMPTNO,CMPTEL,CMPTFA,INREFA
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "nlofes.h"
#include "nlofct.h"
#include "optct.h"
#ifdef MED
#include "med.hf"
#endif
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINR,NELRAY
C
#ifdef MED
C.. Variables internes
C
C***********************************************************************
C
C     lire la dimension le nombre de noeuds et d'elements
C     lire eventuellement le type d'elements
C
C     4- VERIFICATIONS DIVERSES
C     =========================
C
C--------
C FORMATS
C--------
C 
 1000 FORMAT('  %% ERREUR LRAME1 : LE FICHIER NE CONTIENT PAS UNE S.D.',
     &       ' DE MAILLAGE ')
 1018 FORMAT('  %% ERREUR LRAME1 : DIMENSION DES MAILLAGES ',
     &       'INCOMPATIBLES')
 1021 FORMAT('  %% ERREUR LRAME1 : La dimension du maillage rayonnement'
     &       ' n''est pas coherente',/,
     &       21X,'avec celle du solide')      
 1022 FORMAT('  %% ERREUR LRAME1 : LE MAILLAGE POSSEDE DES'
     &                             ,' NOEUDS MILIEUX')      
 1023 FORMAT('  %% ERREUR LRAME1 : UTILISATION D''ELEMENTS ',
     &                              'NON CONFORMES',/,
     &       20X,'Seuls sont autorises :',/,
     &       20X,' - les triangles (en dimension 3)',/,
     &       20X,' - les segments  (en dimension 2)')
C 
 9999 FORMAT(' %% ERREUR LRAME1 : erreur de lecture du maillage ',
     *       ' rayonnement')
C
#endif
      END
