C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=POSCOT,SSI=0
C
                        SUBROUTINE POSCOT
C                       *****************
C
     * ( CHAINE, IDEB,IFIN,LCH )
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C   FONCTION :                                                         *
C   --------   DETERMINER LA POSITION (debut,fin et longeur) D'UNE     *
C              CHAINE DANS UNE CHAINE                                  *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C               (*)   (*)                 ARGUMENTS                    !
C   .________.______.____._____________________________________________.
C   !  NOM   ! TYPE !MODE!                  ROLE                       !
C   !________!______!____!_____________________________________________!
C   ! CHAINE !   A  ! D  ! CHAINE DS LAQUELLE ON EFFECTUE LA RECHERCHE !
C   !  IDEB  !   E  ! R  ! POSITION+1 DE LA PREMIERE COTE              !
C   !  IFIN  !   E  ! R  ! POSITION-1 DE LA DERNIERE COTE              !
C   !   LCH  !   E  ! R  ! LONGUEUR DE LA CHAINE CONTENANT             !
C   !________!______!____!_____________________________________________!
C   ! COMMONS                                                          !
C   !__________________________________________________________________!
C   !/NLOFES/!      ! D  !                                             !
C   !__________________________________________________________________!
C   ! FONCTIONS IMPLICITES                                             !
C   !__________________________________________________________________!
C   !________!______!____!_____________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C                                   
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C**********************************************************************
C     DONNEES EN COMMON 
C**********************************************************************
C
#include "nlofes.h"
C
C**********************************************************************
C
C
      CHARACTER CHAINE*(*)
      INTEGER IDEB,IFIN,LCH
C
      CHARACTER CC
      INTEGER I
C
C
C**********************************************************************
C     FONCTIONS IMPLICITES
C**********************************************************************
C
C**********************************************************************
C
      I = 1
      IDEB = 0
      IFIN = 0 
      LCH  = 0
C
   10 CONTINUE
C
      READ(CHAINE(I:I),1000,ERR=99,END=99) CC
      IF ( CHAINE (I:I) .EQ. '''' ) THEN
         IF (IDEB.EQ.0) THEN
            IDEB = I+1
         ELSE
            IFIN = I-1
         ENDIF
      ENDIF
C
      I = I+1
      IF (IFIN.EQ.0 .AND. I.LE.200) GOTO 10
C
C
      LCH = IFIN - IDEB + 1
C
      RETURN
C   
   99 WRITE (NFECRA,9000) CHAINE
C
C--------
C FORMATS
C--------
 1000 FORMAT(A1)
 9000 FORMAT(' %% ERREUR POSCOT : CHAINE INCORRECTE',/,
     &       '                   CH = ',A80)
C----
C FIN
C----
C
      RETURN
      END
