C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C
                     SUBROUTINE SMOOGC
C                    *****************
C
C     ----------------------------------------------------
     *( FDFRAY,SUFRAY,NELRAY,X,B,DD,GD,RES,Z,DI)
C      ---------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     SOLVEUR D'UN SYSTEME   A X = B                    *
C                                                                      *
C      Ce sous-programme determine la solution de:                     *
C                                                                      *
C                         A X = B                                      *
C                                                                      *
C      A est une matrice symetrique.                                   *
C      On utilise la methode du gradient conjuge, et le                *
C      preconditionnement par la diagonale.                            *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   X       !  TR  ! M  ! VECTEUR RESULTAT                         !
C   !   B       !  TR  ! D  ! SECOND MEMBRE DE L'EQUATION              !
C   !   DI      !  TR  ! M  ! Diagonale de la matrice                  !
C   !   RES     !  TR  ! M  ! RESIDU                                   !
C   !   GD      !  TR  ! M  ! GRADIENT DE DESCENTE                     !
C   !   DD      !  TR  ! M  ! DIRECTION DE DESCENTE                    !
C   !   Z       !  TR  ! M  ! VECTEUR CONTENANT 'M' MULTIPLIEE PAR DD  !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : OV,PROSCA
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : INISOL
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NELRAY
C
      DOUBLE PRECISION FDFRAY(NELRAY*(NELRAY+1)/2)
      DOUBLE PRECISION SUFRAY(NELRAY)
      DOUBLE PRECISION X(NELRAY),B(NELRAY),DD(NELRAY),GD(NELRAY)
      DOUBLE PRECISION RES(NELRAY),Z(NELRAY),DI(NELRAY)
C 
C..Variables locales
      INTEGER N,I,J,NITSMO
      DOUBLE PRECISION X0,RESNOR,SL,RGRG,RO,PRSCA1,PRSCA2
      DOUBLE PRECISION ALP,EPSIS,ZERO,EPSSMO,S,SS
C      
C***********************************************************************
C    
C     1- INITIALISATION
C     =================
C
C
      ZERO   = 0.D0
      NITSMO = 100
      EPSSMO = 1.E-8
      N = 0
C 
C     1- INITIALISATION DES VECTEURS AUXILIAIRES
C     ========================================== 
        DO 10 I=1,NELRAY
          S  = 0.
          SS = 0.
          DO 11 J=1,I-1
            S  = S  + FDFRAY((J-1)*NELRAY-(J-1)*J/2+I)
            SS = SS + FDFRAY((J-1)*NELRAY-(J-1)*J/2+I)*
     &                FDFRAY((J-1)*NELRAY-(J-1)*J/2+I)
   11     CONTINUE
          S  = S  + FDFRAY((I-1)*NELRAY-(I-1)*I/2+I)
          SS = SS + 2. * FDFRAY((I-1)*NELRAY-(I-1)*I/2+I)*
     &                   FDFRAY((I-1)*NELRAY-(I-1)*I/2+I)
          DO 12 J=I+1,NELRAY
            S  = S  + FDFRAY((I-1)*NELRAY-(I-1)*I/2+J)  
            SS = SS + FDFRAY((I-1)*NELRAY-(I-1)*I/2+J)*
     &                FDFRAY((I-1)*NELRAY-(I-1)*I/2+J)
   12     CONTINUE
          B(I) = SUFRAY(I)-S
          DI(I)= SS          
          X(I) = 0.
   10   CONTINUE
C
C     Norme du second membre 
C     ----------------------
C  
      X0 = 1.D-6
      EPSIS = 1.D-2 * X0
C
      DO 100 I=1,NELRAY
        RES(I) = - B(I)
 100  CONTINUE
C
      CALL PROSCA ( NELRAY,RES,RES,PRSCA1 )
      RESNOR = SQRT ( PRSCA1 )
C
      IF ( RESNOR.LE.EPSIS .AND.  RESNOR.LE.EPSSMO*SQRT(DBLE(NELRAY)))
     & THEN
C
C         Affichage de la precision relative et absolue et sortie
C         -------------------------------------------------------
          IF (NBLBLR.GE.2) THEN
            WRITE(NFECRA,1000)
            WRITE(NFECRA,1010) N,RESNOR/X0,RESNOR/SQRT(DBLE(NELRAY))
          ELSEIF (NBLBLR.GT.0) THEN
            WRITE(NFECRA,2010) N,RESNOR/X0,RESNOR/SQRT(DBLE(NELRAY))
          ENDIF
          RETURN
C
      ENDIF
C
C     2. PROCESSUS ITERATIF
C     =====================
      IF (NBLBLR.GE.2) WRITE(NFECRA,1000)
C
    1 N = N + 1
C
      DO 200 I=1,NELRAY
         GD(I) = RES(I)/DI(I)
 200  CONTINUE
C
      CALL PROSCA ( NELRAY,RES,GD,SL )
      IF ( N .EQ. 1 ) THEN
          CALL OV ( 'X=Y     ',DD,GD,RES,ZERO,NELRAY )
      ELSE 
          ALP = SL / RGRG
          CALL OV ( 'X=Y+CZ  ',DD,GD,DD,ALP,NELRAY )
      ENDIF
      RGRG = SL
C
C     Calcul de Z
C     -----------
      DO 210 I=1,NELRAY
        Z(I) = 0.
        DO 220 J=1,I-1
           Z(I) = Z(I) +  FDFRAY((J-1)*NELRAY-(J-1)*J/2+I)  
     &                  * FDFRAY((J-1)*NELRAY-(J-1)*J/2+I)
     &                  * DD(J)
 220    CONTINUE
        DO 230 J=I+1,NELRAY
           Z(I) = Z(I) +  FDFRAY((I-1)*NELRAY-(I-1)*I/2+J)
     &                  * FDFRAY((I-1)*NELRAY-(I-1)*I/2+J)
     &                  * DD(J)
 230    CONTINUE
        Z(I) = Z(I) + DI(I)*DD(I)
 210  CONTINUE
C
C
      CALL PROSCA ( NELRAY,RES,DD,PRSCA1 )
      CALL PROSCA ( NELRAY,DD,Z,PRSCA2 )  
      RO = - PRSCA1 / PRSCA2
C
      CALL OV ( 'X=X+CY  ',X,DD,RES,RO,NELRAY)
      CALL OV ( 'X=X+CY  ',RES,Z,RES,RO,NELRAY)
C
C     Test de convergence
C     ------------------
      CALL PROSCA ( NELRAY,RES,RES,PRSCA1 ) 
      RESNOR = SQRT ( PRSCA1 )
C
      IF (NBLBLR.GE.10)
     &    WRITE(NFECRA,1010) N,RESNOR/X0,RESNOR/SQRT(DBLE(NELRAY))

      IF ( .NOT. ( (RESNOR.LE.EPSIS .AND.  
     &              RESNOR.LE.EPSSMO*SQRT(DBLE(NELRAY)))
     &                  .OR.  N.GE.NITSMO ) )  
     &    GOTO 1
C
      IF (NBLBLR.GT.0)
     &  WRITE (NFECRA,2010) N,RESNOR/X0,RESNOR/SQRT(DBLE(NELRAY))
C
C     3- MODIFICATION DES COEFS PAR MULTIPLICATEURS DE LAGRANGE
C     ========================================================
      DO 300 I=1,NELRAY
        DO 310 J=I,NELRAY
           FDFRAY((I-1)*NELRAY-(I-1)*I/2+J) =
     &                    FDFRAY((I-1)*NELRAY-(I-1)*I/2+J) *
     &                    (1.D0 + (X(I) + X(J))*
     &                    FDFRAY((I-1)*NELRAY-(I-1)*I/2+J) )
  310 CONTINUE
  300 CONTINUE
C      
C
C--------
C FORMATS
C--------
C 
 1000 FORMAT (/,' *** SMOOGC: SMOOTHING PAR GRADIENT CONJUGUE'
     &       ,/,10X,' ITERATIONS   PRECISION RELATIVE',  
     &       '   PRECISION ABSOLUE')
 1010 FORMAT (13X,I4,11X,E12.5,6X,E12.5)  
 2010 FORMAT (' SMOOGC',I4,' ITERATIONS    PRECISION RELATIVE = ',E12.5,
     &          ' PRECISION ABSOLUE = ', E12.5 )
C
      END    





