C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------

C/MEMBR ADD NAME=SVOLUM,SSI=0
C
                     SUBROUTINE SVOLUM
C                    ******************
C
C     ------------------------------------------------------
     *( NDIM,NDIELE,NELEMS,NDMATS,NELEUS,NDMASS,NPOINS,
     *  VOLUME,SURFUS,NODES,NODEUS,COORDS,NANGLE )
C     -----------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DES VARIABLES VOLUME, TAILLE POUR CHAQUE   *
C                    ELEMENT D'UN MAILLAGE ELEMENT FINI                *
C                                                                      *
C      Dans le cas 2D:  VOLUME = surface du triangle                   *
C                                                                      *
C      Dans le cas 3D:  VOLUME = volume du tetraedre                   *
C                       SURFUS = surface du triangle de bord du        *
C                                maillage definit pour les flux de bord*
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   VOLUME  !  TR  ! R  ! EN 2D : surface du triangle              !
C   !           !      !    ! EN 3D : volume du tetraedre              !
C   !   SURFUS  !  TR  ! D  ! EN 3D SURFACE DU TRIANGLE DE BORD (flux) !
C   !           !      !    ! EN 2D LONGUEUR DU SEGMENT DE BORD (flux) !
C   !   NODES   !  TE  ! D  ! CORRESPONDANCE NOEUDS LOCAUX --> GLOBAUX !
C   !   NODEUS  !  TR  ! D  !     //    NOEUDS BORD LOCAUX --> GLOBAUX !
C   !   COORDS  !  TR  ! D  ! COORDONNEES DU MAILLAGE                  !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ---
C                                     
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : INISOL
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
C      
C***********************************************************************
C
C..Variables externes
      INTEGER NDIM,NDIELE,NELEMS,NDMATS,NELEUS,NDMASS,NPOINS
      DOUBLE PRECISION VOLUME(NELEMS),COORDS(NPOINS,NDIM)
      INTEGER NODES(NELEMS,NDMATS),NODEUS(NELEUS,NDMASS)
      INTEGER NANGLE(NELEMS)
      DOUBLE PRECISION SURFUS(NELEUS)
C
      INTEGER I,N1,N2,N3,N4,N5,N6,N7,N8,N9,N10
      INTEGER NPETIT,NPETIU
      DOUBLE PRECISION EPSVOL,EPSVOU,S6,S23
      DOUBLE PRECISION X1,Y1,Z1
      DOUBLE PRECISION X2,Y2,Z2 
      DOUBLE PRECISION X3,Y3,Z3
      DOUBLE PRECISION X4,Y4,Z4 
      DOUBLE PRECISION X12,Y12,Z12
      DOUBLE PRECISION X13,Y13,Z13
      DOUBLE PRECISION X14,Y14,Z14
C 
C..Variables internes
      DOUBLE PRECISION GRAND,CC
      LOGICAL LVERIF
C
      INTEGER NANG
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      LVERIF = .FALSE.
      GRAND  = 1.0D+6
C  
      EPSVOL = 1.0D-6
C
      S6 = 1.D0 / 6.D0
      S23 = 2.D0 / 3.D0
C
      DO 100 I=1,NELEMS
          VOLUME(I) = 0.D0
          NANGLE(I) = 0
  100 CONTINUE
C
      DO 110 I=1,NELEUS
          SURFUS(I) = 0.D0
  110 CONTINUE
C
      NPETIT = 0
      NPETIU = 0      
C
      NANG=0
C
C     2- CALCUL DE VOLUME , ET SURFUS
C     =======================================
C
C         2.1- Cas d'un espace discretise en triangle
C         -------------------------------------------
          IF ( NDIELE .EQ. 2 ) THEN
C
              EPSVOU = EPSVOL
              EPSVOL = EPSVOL*EPSVOL
C
C             2.1.1- Cas bidimentionnel cartesien et axisymetrique
C             ----------------------------------------------------
              IF ( NDIM .EQ. 2 ) THEN
C             
                DO 211 I=1,NELEMS
C
C                 Indices des noeuds
                  N1 = NODES(I,1)
                  N2 = NODES(I,2)
                  N3 = NODES(I,3)
C 
                  X1 = COORDS(N1,1)
                  Y1 = COORDS(N1,2)
                   X2 = COORDS(N2,1)
                   Y2 = COORDS(N2,2) 
                  X3 = COORDS(N3,1)
                  Y3 = COORDS(N3,2)
C
                  X12 = X2 - X1
                  Y12 = Y2 - Y1
                  X13 = X3 - X1
                  Y13 = Y3 - Y1
C
C                 S = ( 12 Vectoriel 13 ) / 2                   
                  VOLUME(I) = 0.5D0 * ABS ( X12*Y13 - Y12*X13 )
C
                  IF( VOLUME(I) .LT. EPSVOL ) THEN
                      NPETIT = NPETIT + 1
                  ENDIF
C
C                 Reperage des eventuels angles ouverts
                  CC=(X12*X13+Y12*Y13)/
     *                    (SQRT(X12**2+Y12**2)*SQRT(X13**2+Y13**2))
                  IF (CC.LT.0) NANGLE(I)=1
C
                  X12 = X1 - X2
                  Y12 = Y1 - Y2
                  X13 = X3 - X2
                  Y13 = Y3 - Y2
                  CC=(X12*X13+Y12*Y13)/
     *                    (SQRT(X12**2+Y12**2)*SQRT(X13**2+Y13**2))
                  IF (CC.LT.0) NANGLE(I)=2
C
                  X12 = X1 - X3
                  Y12 = Y1 - Y3
                  X13 = X2 - X3
                  Y13 = Y2 - Y3
                  CC=(X12*X13+Y12*Y13)/
     *                    (SQRT(X12**2+Y12**2)*SQRT(X13**2+Y13**2))
                  IF (CC.LT.0) NANGLE(I)=3
C                       
  211           CONTINUE
C
C
C
C             2.1.2- Calcul de SURFUS (segment)
C             ---------------------------------
C             
                DO 212 I=1,NELEUS 
C   
C                 Calcul des indices
                  N1 = NODEUS(I,1)
                  N2 = NODEUS(I,2)
                  N3 = NODEUS(I,3)
C
C 
                  X1 = COORDS(N1,1)
                  Y1 = COORDS(N1,2)
                  X2 = COORDS(N2,1)
                  Y2 = COORDS(N2,2)
C
                  X12 = X2 - X1
                  Y12 = Y2 - Y1
C
                  SURFUS(I) = SQRT ( X12 * X12 + Y12 * Y12 )
C
                  IF( SURFUS(I) .LT. EPSVOU ) THEN
                      NPETIU = NPETIU + 1
                  ENDIF
C
  212           CONTINUE
C                   
C             2.1.3- Cas coque (triangle dans espace 3D)
C             ------------------------------------------
              ELSE
C             
                DO 213 I=1,NELEMS 
C   
C                 Calcul des indices
                  N1 = NODES(I,1)
                  N2 = NODES(I,2)
                  N3 = NODES(I,3)
C
C 
                  X1 = COORDS(N1,1)
                  Y1 = COORDS(N1,2)
                  Z1 = COORDS(N1,3)
                    X2 = COORDS(N2,1)
                    Y2 = COORDS(N2,2) 
                    Z2 = COORDS(N2,3)
                  X3 = COORDS(N3,1)
                  Y3 = COORDS(N3,2)
                  Z3 = COORDS(N3,3)
C
                  X12 = X2 - X1
                  Y12 = Y2 - Y1
                  Z12 = Z2 - Z1
                  X13 = X3 - X1
                  Y13 = Y3 - Y1
                  Z13 = Z3 - Z1
C
C                 S = ( 12 Vectoriel 13 ) / 2                   
                  VOLUME(I) = 0.5D0 * SQRT ( 
     &                 ( Y12*Z13 - Z12*Y13 )*( Y12*Z13 - Z12*Y13 )
     &               + ( X12*Z13 - Z12*X13 )*( X12*Z13 - Z12*X13 )
     &               + ( X12*Y13 - Y12*X13 )*( X12*Y13 - Y12*X13 )
     &                                      )
C
                  IF( VOLUME(I) .LT. EPSVOL ) THEN
                     NPETIT = NPETIT + 1
                  ENDIF
C 
  213         CONTINUE
C
C             Fin du cas portant sur les triangles cartesiens 
C             axisymetriques, et coque
              ENDIF
C
C           
C         2.2- Cas des tetraedres
C         -----------------------
          ELSE
C
              EPSVOU = EPSVOL*EPSVOL
              EPSVOL = EPSVOL*EPSVOL*EPSVOL
C
C             2.2.1- Calcul de VOLUME 
C             -----------------------
              DO 221 I=1,NELEMS
C
C                 Indices des noeuds
                  N1 = NODES(I,1)
                  N2 = NODES(I,2)
                  N3 = NODES(I,3)
                  N4 = NODES(I,4)
C
                  X1 = COORDS(N1,1)
                  X2 = COORDS(N2,1)
                  X3 = COORDS(N3,1)
                  X4 = COORDS(N4,1)
                  Y1 = COORDS(N1,2)
                  Y2 = COORDS(N2,2) 
                  Y3 = COORDS(N3,2)
                  Y4 = COORDS(N4,2)
                  Z1 = COORDS(N1,3)
                  Z2 = COORDS(N2,3) 
                  Z3 = COORDS(N3,3)
                  Z4 = COORDS(N4,3)
C
C                 Calcul du volume
                  X12 = X2 - X1
                  X13 = X3 - X1
                  X14 = X4 - X1
                  Y12 = Y2 - Y1
                  Y13 = Y3 - Y1
                  Y14 = Y4 - Y1
                  Z12 = Z2 - Z1
                  Z13 = Z3 - Z1
                  Z14 = Z4 - Z1
C
                  VOLUME(I) = S6 * ABS ( X12 * ( Y13*Z14 - Z13*Y14 )
     &                                  -X13 * ( Y12*Z14 - Z12*Y14 )
     &                                  +X14 * ( Y12*Z13 - Z12*Y13 ) )
C
                  IF( VOLUME(I) .LT. EPSVOL ) THEN
                      NPETIT = NPETIT + 1
                      WRITE(NFECRA,300) I,VOLUME(I)
                      WRITE(NFECRA,301) N1,N2,N3,N4
                      WRITE(NFECRA,302) N1,X1,Y1,Z1
                      WRITE(NFECRA,302) N2,X2,Y2,Z2
                      WRITE(NFECRA,302) N3,X3,Y3,Z3
                      WRITE(NFECRA,302) N4,X4,Y4,Z4                      
                  ENDIF
C
C                 Reperage des eventuels angles ouverts
c                  a completer si ca marche en 2D....
c                  CC=(X12*X13+Y12*Y13+Z12*Z13)/
c     *                    (SQRT(X12**2+Y12**2+Z12**2)*
c     *                     SQRT(X13**2+Y13**2+Z13**2))
c                  IF (CC.LT.0) NANGLE(I)=1
C                       
  221         CONTINUE
C
C
C             2.2.5- Calcul de SURFUS
C             -----------------------
              DO 225 I=1,NELEUS
C   
C                 Calcul des indices
                  N1 = NODEUS(I,1)
                  N2 = NODEUS(I,2)
                  N3 = NODEUS(I,3)
C
C 
                  X1 = COORDS(N1,1)
                  X2 = COORDS(N2,1)
                  X3 = COORDS(N3,1)
                  Y1 = COORDS(N1,2)
                  Y2 = COORDS(N2,2) 
                  Y3 = COORDS(N3,2)
                  Z1 = COORDS(N1,3)
                  Z2 = COORDS(N2,3)
                  Z3 = COORDS(N3,3)
C
                  X12 = X2 - X1
                  X13 = X3 - X1
                  Y12 = Y2 - Y1
                  Y13 = Y3 - Y1
                  Z12 = Z2 - Z1
                  Z13 = Z3 - Z1
C
C                 Calcul de la surface  
                  SURFUS(I) = 0.5D0 * SQRT ( 
     &              ( Y12*Z13 - Z12*Y13 ) * ( Y12*Z13 - Z12*Y13 )
     &            + ( X12*Z13 - Z12*X13 ) * ( X12*Z13 - Z12*X13 )
     &            + ( X12*Y13 - Y12*X13 ) * ( X12*Y13 - Y12*X13 )
     &                                      ) 
C
C
                  IF( SURFUS(I) .LT. EPSVOU ) THEN
                      NPETIU = NPETIU + 1
                  ENDIF
C                       
  225         CONTINUE
C
C         Fin du cas 3D
          ENDIF
C
C     2.3 Statistique et controle des elements degeneres
C     --------------------------------------------------
C
      IF ( NBLBLA.EQ.13 ) THEN
C
         WRITE(NFECRA,1100)
         DO 230 I=1,NELEMS
           WRITE(NFECRA,1110) I,VOLUME(I)
  230    CONTINUE
C
         WRITE(NFECRA,1200)
         DO 231 I=1,NELEUS
           WRITE(NFECRA,1210) I,SURFUS(I)
  231    CONTINUE 
C
         IF (NDIM.EQ.2) THEN
           DO I=1,NELEMS
             WRITE(NFECRA,104) I,NANGLE(I)
           ENDDO
           DO I=1,NELEMS
             IF(NANGLE(I).GE.1) NANG=NANG+1
           ENDDO
           WRITE(NFECRA,105) NANG
         ENDIF
C
      ENDIF
C
C     
      IF ( NPETIT .GE. 1 .OR. NPETIU .GE. 1 ) THEN
         WRITE(NFECRA,2000) NPETIT,NPETIU
         STOP
      ENDIF
C
C--------
C FORMATS
C--------
C 
  104 FORMAT (' SVOLUM : ELEMENT A ANGLE OUVERT ',I7,I7)
  105 FORMAT (' SVOLUM : NOMBRE ELEMENT AVEC ANGLE OUVERT ',I7)
  300 FORMAT (' SVOLUM : ELEMENT DEGENERE : ',I10,' VOLUME :',E12.5)
  301 FORMAT (' SVOLUM : NOEUDS N1 N2 N3 N4 :',4I12)
  302 FORMAT (' SVOLUM : NOEUD :',I12,' COORDS :',3E15.5)
 1100 FORMAT (' SVOLUM : NUMERO DE L''ELEMENT ET VOLUME')
 1110 FORMAT (I6,1X,E10.4)
 1200 FORMAT (' SVOLUM : NUMERO DE L''ELEMENT DE BORD ET SURFUS')
 1210 FORMAT (I6,1X,E10.4)
 2000 FORMAT (/,' %% ERREUR SVOLUM : ',/
     &      'NOMBRE D''ELEMENTS DEGENERES         ',I4,/,
     &  19X,'NOMBRE D''ELEMENTS DE BORD DEGENERES ',I4 ) 
C
      RETURN
      END 
